/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorentry.cpp
*/
#include "colorentry.h"
#include <chunk.h>
char *CcolorPic2[] = {
		"15 13 3 1",
		" 	c None",
		".	c #000000",
		"+	c #FFFFFF",
		".++.++.++.++.++",
		"+.++.++.++.++.+",
		"++.++.++.++.++.",
		".++.++.++.++.++",
		"+.++.++.++.++.+",
		"++.++.++.++.++.",
		".++.++.++.++.++",
		"+.++.++.++.++.+",
		"++.++.++.++.++.",
		".++.++.++.++.++",
		"+.++.++.++.++.+",
		"++.++.++.++.++.",
		".++.++.++.++.++"};
colorEntry::colorEntry(textureBase *p):textureBase(COLORENTRY,p)
{
int i;
colorEntry *ce;
double x=0.1;
	parent=p;
	r = 0.0;
	g = 0.0;
	b = 0.0;
	t = 0.0;
	f=0.0;
	range=0.1;
	for (i=0i;i<17;i++) PicBuf[i]=NULL;
	setName("Color");
	setSubItems(false);

	if (p!=NULL) {
		ce=(colorEntry *)(p->getFirstElement());
		while (ce!=NULL) {
			printf("x=%g   range=%g\n",x,ce->getRange() );
			if (ce->getRange()>=x) x=ce->getRange()+0.1;
			ce=(colorEntry *)(p->getNextElement());
		}
		if (x>1) x=1.0;
		r=x;g=x;b=x;
		setRange(x);
	}
	updateInfo();
}

const char **colorEntry::getXPM()
{
int r1=(int)(getRed()*255);
int g1=(int)(getGreen()*255);
int b1=(int)(getBlue()*255);

int r2=255-(int)(getTransparency()*255 );
int g2=255-(int)(getTransparency()*255 );
int b2=255-(int)(getTransparency()*255 );


char *buffer1,*buffer2;
int i;
	

	buffer1=(char *)malloc(128);
	buffer2=(char *)malloc(128);
	sprintf(buffer1,"+\tc #%02x%02x%02x",r1,g1,b1);
	sprintf(buffer2,".\tc #%02x%02x%02x",r2,g2,b2);

	for (i=0i;i<17;i++) if (PicBuf[i]) delete PicBuf[i];
	
	for (i=0;i<17;i++) PicBuf[i]=strdup(CcolorPic2[i]);
	strncpy(PicBuf[3],buffer1,11); //Color
	strncpy(PicBuf[2],buffer2,11); //Transparenz

	free(buffer1);
	free(buffer2);

	return (const char **)&PicBuf;
}

void colorEntry::updateInfo()
{
char *buffer=(char *)malloc(512);
	sprintf(buffer,"Range:%g   (R=%g,G=%g,B=%g,T=%g)",range,r,g,b,t);
	setInfo(buffer);
	free(buffer);
}

colorEntry::~colorEntry()
{
int i;
	for (i=0i;i<17;i++) if (PicBuf[i]) delete PicBuf[i];
}

bool colorEntry::isEqual(textureBase *tb)
{
colorEntry *c=(colorEntry*)tb;
#ifdef DEBUG
	printf("Comparing ColorEntries..\n");
#endif
	if (tb==NULL) return false;
printf("1\n");
	if (tb->getType()!=COLORENTRY) return false;
printf("2\n");
	if (textureBase::isEqual(tb)==false) return false;
printf("3\n");
	if (

		(fabs((float)(r-c->getRed()))<=0.01) &&
		(fabs((float)(g-c->getGreen()))<=0.01)&&
		(fabs((float)(b-c->getBlue()))<=0.01)&&
		(fabs((float)(t-c->getTransparency()))<=0.01)&&
		(fabs((float)(f-c->getFilter()))<=0.01)&&
		(fabs((float)(range-c->getRange()))<=0.01)
	) {
#ifdef DEBUG
	printf("Compared ColorEntries..found it !\n");
#endif
		return true;
	}
printf("%g || \n",1*fabs(r-c->getRed() ));
printf("%g || \n",1*fabs(g-c->getGreen() ));
printf("%g || \n",1*fabs(b-c->getBlue() ));
printf("%g || \n",1*fabs(t-c->getTransparency() ));
printf("%g || \n",1*fabs(f-c->getFilter() ));

	return true;		 /// !!!!!!!!!!!!!!!!!!!
}

void colorEntry::setRed(double a)
{
	a=a+0.005;
	a=a-0.005;
	r=a;
	updateInfo();
}

void colorEntry::setGreen(double a)
{
	a=a+0.005;
	a=a-0.005;
	g=a;
	updateInfo();
}

void colorEntry::setBlue(double a)
{
	a=a+0.005;
	a=a-0.005;
	b=a;
	updateInfo();
}

void colorEntry::setTransparency(double a)
{
	a=a+0.005;
	a=a-0.005;
	t=a;
	updateInfo();
}

void colorEntry::setFilter(double a)
{
	a=a+0.005;
	a=a-0.005;
	f=a;
	updateInfo();
}

double colorEntry::getRed()
{
	return r;
}


double colorEntry::getGreen()
{
	return g;
}
double colorEntry::getBlue()
{
	return b;
}
double colorEntry::getTransparency()
{
	return t;
}

double colorEntry::getFilter()
{
	return f;
}
void colorEntry::add(textureBase *tb)
{
int ty=tb->getType();
	if (ty==COLOR) {
		color *c=(color *) tb;
		r=c->red();
		g=c->green();
		b=c->blue();
		t=c->transparency();
		f=c->filter();
		range=0;
	}		
	if (ty==COLORENTRY) {
		colorEntry *c=(colorEntry *) tb;
		r=c->getRed();
		g=c->getGreen();
		b=c->getBlue();
		t=c->getTransparency();
		f=c->getFilter();
		range=c->getRange();
	}
	updateInfo();
}

bool colorEntry::canAdd(textureBase *tb)
{
int t=tb->getType();
	if (t==COLOR) return true;
	if (t==COLORENTRY) return true;
	return false;
}


void	colorEntry::setRange(double n)
{
	n=n+0.005;
	n=n-0.005;
	range=n;
	updateInfo();
}

double	colorEntry::getRange()
{
	return range;
}

int	colorEntry::save(media *m)
{
chunk ch;
	if(!m) return -1;
	#ifdef DEBUG
		printf("Saving ColorEntry\n");
	#endif
	setMedia(m);
	
	writeChunk("COLE");
	
	textureBase::save(m);

	ch.setMedia(m);
	ch.writeChunk("DATA");

		m->write(&range,sizeof(double) );
		m->write(&r,sizeof(double) );
		m->write(&g,sizeof(double) );
		m->write(&b,sizeof(double) );
		m->write(&t,sizeof(double) );
		m->write(&f,sizeof(double) );
	ch.writeChunkLen();

	writeChunkLen();	
	#ifdef DEBUG
		printf("ColorEntry saved\n");
	#endif*/
	return 0;
}

int	colorEntry::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	pos = m->tell(),len;

	if(!m)	return -1;

	#ifdef DEBUG
		printf("loading ColorEntry\n");
	#endif

	setMedia(m);


	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"DATA",4) == 0) {
			m->read(&range,sizeof(double) );
			m->read(&r,sizeof(double) );
			m->read(&g,sizeof(double) );
			m->read(&b,sizeof(double) );
			m->read(&t,sizeof(double) );
			m->read(&f,sizeof(double) );
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("ColorEntry loaded\n");
	#endif
	updateInfo();
	return 0;
}

int	colorEntry::exportPOV(FILE *fp,int tab,int tabsize, int a,bool dummy)
{
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting ColorEntry (POV)\n");
	#endif
	printTab(fp,tab);
		fprintf(fp,"[ %g  color rgbt<%g,%g,%g,%g> ]",range,r,g,b,t);
	fprintf(fp,"\n");
	#ifdef DEBUG
		printf("ColorEntry exported (POV)\n");
	#endif
	return 0;
}

