/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** world.h
*/
#ifndef __WORLD_H__
#define __WORLD_H__

#include <classes.h>

#include "refptr.h" 
#include "ref.h"

#include "view.h"

#include <texturelibrary.h>

class world : public base
{
protected:
	list<ref*>	referencelist;
	list<body*>	objectlist;
	list<view*>	viewlist;

	TextureLibrary	*tlib;

	Vector3		ambient_light;
	double		assumed_gamma;
	Vector3		background_color;

public:
	world(const char *n = "Untitled");
	world(world *wc);
	~world();

	base		*copy();

	int		addView(view *v);
	view		*getView(char *name);
	view		*getView(int);
	int		removeView(view *v);
 	int		getNumViews();

	TextureLibrary	*getTextureLibrary();

	// temporre Funktion bis texturemap->copy()
	void		setTextureMapNull()
	{
		tlib = 0;
	}
 
	virtual void	dumpNames(int tabsize = 2); 
	virtual void	dumpNames(int,int); 
 
	virtual int	save(media*);
	virtual int	load(media*,int);
 
	virtual int	exportPOV(FILE*,int tab,int tabsize,int); 

	virtual int	addToParent(base *parent);
	virtual int	removeFromParent();

	virtual int	addChild(body *child);
	virtual int	addChild(csgobj *child);
	virtual int	addChild(blobobj *child);
	virtual int	addChild(nonsolid *child);
	virtual int	addChild(refptr *child);
	virtual int	addChild(ref *child);

	virtual int	removeChild(base *child);
	virtual int	removeChild(body*); 
	virtual int	removeChild(refptr*); 
	virtual int	removeChild(ref*); 
	virtual int	removeChild(csgobj*); 
	virtual int	removeChild(blobobj*); 
//	virtual int	removeChild(sphere*) {return -1;}; 
//	virtual int	removeChild(cylinder*) {return -1;}; 
	virtual int	removeChild(nonsolid*);  

	virtual void	getChildren(base ***b)
	{
		int	t,i;
		base	**bt;

		*b = NULL;
		bt = (base**)malloc(sizeof(void*) * (objectlist.length() + referencelist.length() + 1));
		if(!bt) return;

		for(t = 0;t < referencelist.length();t++)
			bt[t] = referencelist[t];
		for(i = 0;i < objectlist.length();i++)
			bt[t + i] = objectlist[i];
		bt[t + i] = NULL;
		*b = bt;
	}

	virtual int	existsName(const char *n);
	virtual base	*searchName(const char *n);

	virtual int	draw(view*,Matrix44,int); 
	virtual int	calculate(int anim = 0); 

	Vector3		getAmbientLight();
	void		setAmbientLight(double r,double g,double b);
	void		setAmbientLight(Vector3);
	void		setAmbientLight(double);

	Vector3		getBackgroundColor();
	void		setBackgroundColor(double r,double g,double b);
	void		setBackgroundColor(Vector3);
};

#endif

