/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** spotlight.h
*/
#ifndef __SPOTLIGHT_H__
#define __SPOTLIGHT_H__

#include <classes.h>


class spotlight : public lightobj
{
protected:
	double		r,g,b;
	double		fade_distance;
	double		fade_power;
	int		atmos_attenuation;
	Vector3		point_at;
	double		radius, falloff, tightness;

public:
	spotlight(base *p=0,char *n="Untitled");
	spotlight(base*,char*,Vector3&,Vector3&,Vector3&);
	spotlight(base*,spotlight*);
	~spotlight();

	virtual base	*copy(base*);

	void SetColor(double, double, double);
	void SetFadeDistance(double);
	void SetFadePower(double);
	void SetAtmosAtt(int);
	void SetPointAt(Vector3 );
	void SetPointAt(double, double, double);
	void SetTightness(double);
	void SetRadius(double);
	void SetFallOff(double);

	virtual int	addToParent(base *p);
	virtual int	removeFromParent();

	virtual int	exportPOV(FILE *f,int,int,int);
	virtual void	dumpNames(int,int);

	virtual int	save(media *);
	virtual int	load(media *,int);

	virtual int	draw(view*,Matrix44,int);
	virtual int	calculate(int);
	virtual int	isFinite();
};

#endif	
