/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** script.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "script.h"

script::script(base *p,char *n,char *t) :
	nonsolid(p,n)
{
	numtype = NUM_SCRIPT;
	if(t) textdata = strdup(t);
	if(parent) addToParent(parent);
}

script::~script()
{
	if(textdata)
	{
		free(textdata);
	}
}

void	script::setText(char *t)
{
	if(textdata) free(textdata);

	textdata = strdup(t);
}

char	*script::getText()
{
	return textdata;
}

void	script::dumpNames(int tab,int)
{
	printTab(stdout,tab);
	printf("script %s\n",name);
}

int	script::exportPOV(FILE *fp,int tab,int tabsize,int anim) 
{ 
	char	*cp,*tmpstr; 
 
	if(isFlag(NO_EXPORT)) return 0;

	printTab(fp,tab); 
	fprintf(fp,"// Objectname = %s\n",name); 
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = script\n");

	printTab(fp,tab);
	fprintf(fp,"{\n");

	if(textdata)
	{
		tmpstr = strdup(textdata);
		for(cp = strtok(tmpstr,"\n");cp != NULL;cp = strtok(NULL,"\n"))
		{
			printTab(fp,tab + tabsize);
			while(*cp == ' ' || *cp == '\t') cp++;
			fprintf(fp,"%s\n",cp);
		}
		free(tmpstr);
	}

	dim::exportPOV(fp,tab + tabsize,tabsize,anim);

	printTab(fp,tab);
	fprintf(fp,"}\n");

	return 0;
}

int	script::save(media *m)
{
	int	l;

	setMedia(m);
	writeChunk("SCPT");
	writeNameChunk(name);

	saveFlags(m);

	l = strlen(textdata);
	m->write(&l,4);
	m->write(textdata,l);

	anim::save(m);
	dim::save(m);

	writeChunkLen();

	return 0;
}

int	script::load(media *m,int l)
{
	int	pos = m->tell();

	loadFlags(m,l);

	textdata = readName();

	anim::load(m,l - (m->tell() - pos));
	dim::load(m,l - (m->tell() - pos));

	return 0;
}





