/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** obj.h
*/
#ifndef __OBJECT_H__
#define __OBJECT_H__

#include <stdio.h>

#include <num.h>
#include <list.h>

#include <classes.h>

#include "refptr.h"
#include "blob.h"

class obj : public body
{
protected:
	list<body*>	children;

public:
	obj(base *p=0,char *n="Untitled",texture *t = 0);
	obj(base *p,char *n,Vector3&,Vector3&,Vector3&);
	obj(base *p,char *n,texture *t,Vector3&,Vector3&,Vector3&);
	obj(base *p,obj *oc);
	~obj();

	void		dumpNames(int tabsize = 2);
	void		dumpNames(int,int);

	virtual int	save(media*);
	virtual int	load(media*,int);

	int		exportPOV(FILE*,int tab,int tabsize,int anim = 0);

	virtual int	addToParent(base*);
	virtual int	removeFromParent();

	virtual int	addChild(body*);
	virtual int	addChild(refptr*);
	virtual int	addChild(csgobj*);
	virtual int	addChild(blob*);
	virtual int	addChild(blobobj*);
	virtual int	addChild(nonsolid*);

	virtual int	removeChild(body *);
	virtual int	removeChild(refptr*);
	virtual int	removeChild(csgobj*);
	virtual int	removeChild(blob*);
	virtual int	removeChild(blobobj*);
	virtual int	removeChild(nonsolid*);

	virtual base	*copy(base *);

	virtual void	getChildren(base ***b)
	{
		int	t;
		base	**bt;

		*b = NULL;
		bt = (base**)malloc(sizeof(void*) * (children.length() + 1));
		if(!bt) return;

		for(t = 0;t < children.length();t++)
			bt[t] = children[t];
		bt[t] = NULL;
		*b = bt;
	}

	virtual int	hasChild(body *);

	virtual base	*searchName(const char *n);
	virtual int	existsName(const char *n);

	virtual int	draw(view*,Matrix44,int);
	virtual int	calculate(int);

	virtual double	volume(int anim = 0);
};

#endif	
