/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** mesh.h
*/
#ifndef __MESH_H__
#define __MESH_H__

#include <list.h>

#include <classes.h>

struct tri
{
	Vector3	p1;
	Vector3	p2;
	Vector3	p3;
	int smooth;
	Vector3	n1;
	Vector3	n2;
	Vector3	n3;
};
		

class mesh : public nonsolid
{
protected:
	simplelist<tri> tlist;

public:
	mesh(base *p=0,char *n="Untitled",texture *t=0);
	mesh(base *p,char *n,Vector3&,Vector3&,Vector3&);
	mesh(base *p,char *n,texture *t,Vector3&,Vector3&,Vector3&);
	mesh(base *p,mesh *mc);
	~mesh();

	void		addTriangle(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3);
	void		addTriangle(Vector3 v1, Vector3 v2, Vector3 v3);
	void		removeTriangle(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3);
	void		removeTriangle(Vector3 v1, Vector3 v2, Vector3 v3);

	void		setNormal(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3);
	void		setNormal(Vector3 v1, Vector3 v2, Vector3 v3);
	void		setSmooth(int s);

	virtual int	addToParent(base *);
	virtual int	removeFromParent();

	virtual base	*copy(base*);

	virtual void	dumpNames(int,int);

	virtual int	exportPOV(FILE *,int,int,int anim = 0);
	virtual int	save(media *);
	virtual int	load(media *,int);

	virtual int	draw(view *,Matrix44,int)
	{
		return -3;
	}
	virtual int	calculate(int) {return 0;};
};


#endif



