/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** dim.h
*/
#ifndef __DIM_H__
#define __DIM_H__

#include "num.h"
#include "list.h"
#include "base.h"

class dim : public base
{
protected:
	Vector3		vscale,vrotate,vtranslate;
	Vector3		vascale,varotate,vatranslate;

public:
	dim(base *p = 0,const char *n="Untitled");
	dim(base *p,const char *n,Vector3&,Vector3&,Vector3&);
	dim(base *p,dim *);
	~dim();

	void			translate(Vector3 v);
	int			atranslate(param**,list<param*>*);
	int			asetTranslation(param**,list<param*>*);
	int			agetTranslation(param**,list<param*>*);
	int			agetPosition(param**,list<param*>*);

	void			rotate(Vector3 v);
	int			arotate(param**,list<param*>*);
	int			asetRotation(param**,list<param*>*);
	int			agetRotation(param**,list<param*>*);
	int			agetAngle(param**,list<param*>*);

	void			scale(Vector3 v);
	void			scale(double d);
	int			ascale(param**,list<param*>*);
	int			asetScalation(param**,list<param*>*);
	int			agetScalation(param**,list<param*>*);
	int			agetSize(param**,list<param*>*);

	Vector3			&getVScale()
	{
		return vscale;
	}
	Vector3			&getVRotate()
	{
		return vrotate;
	}
	Vector3			&getVTranslate()
	{
		return vtranslate;
	}
	void			setVScale(Vector3 &v)
	{
		vscale = v;
	}
	void			setVRotate(Vector3 &v)
	{
		vrotate = v;
	}
	void			setVTranslate(Vector3 &v)
	{
		vtranslate = v;
	}

	void			dimMatrix(Matrix44 &m,int anim = 0);

	virtual int		addToParent(base*) = 0;
	virtual int		removeFromParent() = 0;

	virtual base		*copy(base *parent) = 0;

	virtual Matrix44	getMatrix(int anim = 0);

	virtual int		exportPOV(FILE*,int tab,int tabsize,int anim) = 0;

	virtual void		dumpNames(int tab,int tabsize) = 0;

	virtual int		save(media*);
	virtual int		load(media*,int);
};

#endif	
