/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** boundingbox.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "boundingbox.h"
#include "view.h"


boundingbox::boundingbox()
{
	calculate();
}

boundingbox::~boundingbox()
{
}

int	boundingbox::calculate(int)
{
	return 0;
}

int	boundingbox::drawBB(view *v,Matrix44 m,int anim)
{
	Vector3	p,vx,vy,vz;

	//printf("BoundingBox\n");

	calculate();

	p = Vector3((vmin[0] + vmax[0]) / 2,(vmin[1] + vmax[1]) / 2,(vmin[2] + vmax[2]) / 2);
	vx = Vector3((vmax[0] - vmin[0]) / 2,0,0);
	vy = Vector3(0,(vmax[1] - vmin[1]) / 2,0);
	vz = Vector3(0,0,(vmax[2] - vmin[2]) / 2);

	v->drawBox(p,vx,vy,vz,m,anim);

	return 0;
}

Vector3	boundingbox::min()
{
	return vmin;
}

Vector3	boundingbox::max()
{
	return vmax;
}


