/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** body.h
*/
#ifndef __BODY_H__
#define __BODY_H__

#include "dim.h"

#include <texture.h>
#include <texturelibrary.h>

class body : public dim
{
protected:
	texture		*texptr;
	double		d_weight;

public:
	body(base *p = 0,const char *n="Untitled",texture *t=0);
	body(base *p,const char *n,Vector3&,Vector3&,Vector3&);
	body(base *p,const char *n,texture*,Vector3&,Vector3&,Vector3&);
	body(base *p,body*);
	~body();

	virtual int	exportPOV(FILE*,int tab,int tabsize,int anim = 0) = 0; 

	virtual int	addToParent(base*) = 0;
	virtual int	removeFromParent() = 0;

	void		setTexture(texture *t);
	texture		*getTexture();
	int		saveTexture(media*);
	int		loadTexture(media*,int);
	virtual int	save(media*) = 0;
	virtual int	load(media*,int) = 0;

	texture		*findTexture(char *n);

	virtual int	draw(view*,Matrix44,int) = 0; 

	void		setSpecificWeight(double);
	double		specificWeight();

	double		weight();

	virtual double	volume(int anim = 0) = 0;
};

#endif	
