/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** param.cpp
*/
#include "param.h"

#include <stdlib.h>
#include <string.h>

#include <matmath.h>
#include <list.h>

param::param()
{
	dvalid = 0;
	pmtype = PM_NONE;
}

param::~param()
{
}

int	param::type()
{
	return pmtype;
}

int	param::valid()
{
	return dvalid;
}

void	param::setValidity(int v = 1)
{
	dvalid = v;
}


pmbool::pmbool(int b) :
	param()
{
	dbool = b;
	pmtype = PM_BOOL;
}

int	pmbool::value()
{
	return dbool;
}

void	pmbool::setBool(int b)
{
	dbool = b;
	setValidity();
}


pmchar::pmchar(char c = 0) :
	param()
{
	dchar = c;
	pmtype = PM_CHAR;
}

char	pmchar::getChar()
{
	return dchar;
}

void	pmchar::setChar(char c)
{
	dchar = c;
	setValidity();
}

pmint::pmint(int i = 0) :
	param()
{
	dint = i;
	pmtype = PM_INT;
}

int	pmint::getInt()
{
	return dint;
}

void	pmint::setInt(int i)
{
	dint = i;
	setValidity();
}

pmreal::pmreal(double r = 0) :
	param()
{
	dreal = r;
	pmtype = PM_REAL;
}

double	pmreal::real()
{
	return dreal;
}

void	pmreal::setReal(double r)
{
	dreal = r;
	setValidity();
}

pmvector::pmvector(Vector3 v) :
	param()
{
	dvector = v;
	pmtype = PM_VECTOR;
}

pmvector::pmvector(double x = 0,double y = 0,double z = 0) :
	param()
{
	dvector = Vector3(x,y,z);
	pmtype = PM_VECTOR;
}

Vector3	pmvector::vector()
{
	return dvector;
}

void	pmvector::setVector(Vector3 v)
{
	dvector = v;
	setValidity();
}

pmtext::pmtext(char *c = 0) :
	param()
{
	dtext = c;
	pmtype = PM_TEXT;
}

char	*pmtext::getText()
{
	return dtext;
}

void	pmtext::setText(char *c)
{
	dtext = c;
	setValidity();
}


pmobject::pmobject(char *c = 0) :
	param()
{
	dname = c;
	pmtype = PM_OBJECT;
}

char	*pmobject::getName()
{
	return dname;
}

void	pmobject::setName(char *c)
{
	dname = c;
	setValidity();
}



