/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** anim.h
*/
#ifndef __ANIM_H__
#define __ANIM_H__

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <matmath.h>
#include <media.h>
#include <chunk.h>
#include <list.h>

#include "param.h"

#ifdef call
#undef call
#endif

#include "communication.h"

class anim;

typedef int (anim::*methodfn)(param**,list<param*>*);

class method
{
protected:
	char		*d_name;
	methodfn	d_fn;

public:

	method(char *n,methodfn f);
	method(method*);
	~method();

	char	*name();

	int	call(anim *caller,param **pr,list<param*> *pl);
};

class animscript
{
protected:
	char	*d_name;
	char	*d_script;

public:

	animscript(char *n,char *t);
	animscript(animscript*);
	~animscript();

	void	setScript(char *t);
	char	*scripttext();
	char	*name();
};

class variable
{
protected:
	char	*d_name;
	char	*d_value;

public:

	variable(char *n,char *v = 0);
	~variable();

	void	setValue(char *v);
	char	*value();
	char	*name();
};

class anim
{
protected:
	list<method*>		methodlist;
	list<animscript*>	scriptlist;
	list<variable*>		variablelist;

public:
	anim();
	anim(anim*);

	~anim();

	void	listMethods();

	void	addScript(char *n,char *t);
	void	delScript(char *n);
	char	**getScriptList();

	void	setText(char *name,char *t);
	char 	*getText(char *name);

	int	call(char *n,param **pr,list<param*> *pl,char *tmpdir,com *c,int time,int start,int end,int stepsize);
	int	callscript(char *fn,char *tmpdir,com *c,int time,int start,int end,int stepsize,param **pr=0,list<param*> *pl=0); 	int	save(media*);
	int	load(media*,int);

protected:

	int	addMethod(char *n,methodfn f);
	int	delMethod(char *n);

private:

	int	makeParam(param **p,char *pstr);

	char	*getValue(char *n);
	void	setValue(char *n,char *v);
};


#endif

