#!/bin/sh
#
#

# Arguments:
# The readchannel
CRead=$1
# The writechannel
CWrite=$2
# The current time in ms
Time=$3
# The start time in ms
StartTime=$4
# The end time in ms
EndTime=$5
# The stepsize in ms
StepSize=$6

# CALL(command,parameterstring)
function CALL()
{
	echo "CMNDTHIS $1 $2" 1>&$CWrite
	read Result 0<&$CRead
	echo $Result
}

# OBJECT(name,command,parameterstring)
function OBJECT()
{
	echo "CMND$1 $2 $3" 1>&$CWrite
	read Result 0<&$CRead
	echo $Result
}

# PRINT(string)
function PRINT()
{
	echo "PRNT$1" 1>&$CWrite
	# Wait for "OK"
	read Result 0<&$CRead
}

# ERROR(string)
function ERROR()
{
	echo "ERRR$1" 1>&$CWrite
	# Wait for "OK"
	read Result 0<&$CRead
}

# EXIT()
function EXIT()
{
	# Send EXIT (I leave the shell)
	echo "EXIT" >&$CWrite
}

# CALC(string)
function CALC()
{
	echo "CALC $1" 1>&$CWrite
	read Result 0<&$CRead
	echo "$Result"
}

# GETN(returnvalue,n)
function GETN()
{
	rv=$1
	n=$2
	t=`echo $rv | cut -b 1`
	if test  $t = "V"
	then
		echo `echo $rv | tr '\040' '\011' | cut -b 2-20 | cut -f $n`
	else
		echo "error"
	fi
}

# GETX(returnvalue)
function GETX()
{
	GETN "$1" 1
}

# GETY(returnvalue)
function GETY()
{
	GETN "$1" 2
}

# GETZ(returnvalue)
function GETZ()
{
	GETN "$1" 3
}

# LOAD(name)
function LOAD()
{
	echo "LOAD$1" 1>&$CWrite
	read Result 0<&$CRead
	echo "$Result"
}

# SAVE(name,value)
function SAVE()
{
	echo "SAVE$1=$2" 1>&$CWrite
	read Result 0<&$CRead
}

# ARGC()
function ARGC()
{
	echo "ARGC" 1>&$CWrite
	read Result 0<&$CRead
	echo $Result
}

# ARGT(argn)
function ARGT()
{
	argn=$1
	echo "ARGT$argn" 1>&$CWrite
	read Result 0<&$CRead
	echo $Result
}

# ARGV(argn)
function ARGV()
{
	argn=$1
	echo "ARGV$argn" 1>&$CWrite
	read Result 0<&$CRead
	echo $Result
}


