// Objectname = camera
// Objecttype = view

#declare f=30;

camera
{
#ifdef (LEFTEYE)
    location  <59 + 0.0380221 * f,14 - 0.000276016 * f,190>
#else
	#ifdef (RIGHTEYE)
	    location  <59 - 0.0380221 * f,14 + 0.000276016 * f,190>
	#else
	    location  <59,14,190>
	#end
#end
    sky       <0,1,0>
    up         <-0.000322596,0.0219446,-0.00153898>
    right      <-0.0380221,0.000276016,0.0119059>
    look_at    <0,0,0>
}

// Global settings
global_settings
{
    ambient_light rgb<100,100,100>
    assumed_gamma 2.2
}


// Objectname = World
// Objecttype = world


// Objectname = Arachnoid
// Objecttype = csg (union)
union
{
    // Objectname = Head
    // Objecttype = csg (union)
    union
    {
        // Objectname = Sphere
        // Objecttype = sphere
        sphere
        {
            <0,0,0>,0.5
            scale     <1,1,1>
            rotate    <0,0,0>
            translate <0,0,0>
        }

        scale     <1,1,1>
        rotate    <0,0,0>
        translate <1.5,0,0>
    }
    // Objectname = Tail
    // Objecttype = csg (union)
    union
    {
        // Objectname = Tailbody
        // Objecttype = sphere
        sphere
        {
            <0,0,0>,0.5
            scale     <1,1,1>
            rotate    <0,0,0>
            translate <0,0,0>
        }

        scale     <2,0.6,1.3>
        rotate    <0,0,0>
        translate <-2,0,0>
    }
    // Objectname = Body
    // Objecttype = csg (union)
    union
    {
        // Objectname = BodyBody
        // Objecttype = sphere
        sphere
        {
            <0,0,0>,0.5
            scale     <3,1,2>
            rotate    <0,0,0>
            translate <0,0,0>
        }

        // Objectname = ArachnoidLegR1
        // Objecttype = csg (union)
        union
        {
            // Objectname = ArachnoidLegR1Seg1
            // Objecttype = csg (union)
            union
            {
                // Objectname = ArachnoidLegR1Body1
                // Objecttype = sphere
                sphere
                {
                    <0,0,0>,0.5
                    scale     <5,0.7,0.7>
                    rotate    <0,0,0>
                    translate <2.4,0,0>
                }

                // Objectname = ArachnoidLegR1Seg2
                // Objecttype = csg (union)
                union
                {
                    // Objectname = ArachnoidLegR1Body2
                    // Objecttype = sphere
                    sphere
                    {
                        <0,0,0>,0.5
                        scale     <4,0.55,0.55>
                        rotate    <0,0,0>
                        translate <1.9,0,0>
                    }

                    // Objectname = ArachnoidLegR1Seg3
                    // Objecttype = csg (union)
                    union
                    {
                        // Objectname = ArachnoidLegR1Body3
                        // Objecttype = sphere
                        sphere
                        {
                            <0,0,0>,0.5
                            scale     <2,0.4,0.4>
                            rotate    <0,0,0>
                            translate <0.9,0,0>
                        }

                        // Objectname = ArachnoidLegR1Seg4
                        // Objecttype = csg (union)
                        union
                        {
                            // Objectname = ArachnoidLegR1Body4
                            // Objecttype = sphere
                            sphere
                            {
                                <0,0,0>,0.5
                                scale     <0.5,0.2,0.2>
                                rotate    <0,0,0>
                                translate <0.4,0,0>
                            }

                            scale     <1,1,1>
                            rotate    <0,0,0>
                            translate <1.9,0,0>
                        }
                        scale     <1,1,1>
                        rotate    <0,0,0>
                        translate <3.9,0,0>
                    }
                    scale     <1,1,1>
                    rotate    <0,0,-90>
                    translate <4.9,0,0>
                }
                scale     <0.5,0.5,0.5>
                rotate    <0,-30,45>
                translate <0,0,0>
            }
            scale     <1.1,1.1,1.1>
            rotate    <0,90,0>
            translate <0.5,0,-0.9>
        }
        // Objectname = ArachnoidLegL1
        // Objecttype = csg (union)
        union
        {
            // Objectname = ArachnoidLegL1Seg1
            // Objecttype = csg (union)
            union
            {
                // Objectname = ArachnoidLegL1Body1
                // Objecttype = sphere
                sphere
                {
                    <0,0,0>,0.5
                    scale     <5,0.7,0.7>
                    rotate    <0,0,0>
                    translate <2.4,0,0>
                }

                // Objectname = ArachnoidLegL1Seg2
                // Objecttype = csg (union)
                union
                {
                    // Objectname = ArachnoidLegL1Body2
                    // Objecttype = sphere
                    sphere
                    {
                        <0,0,0>,0.5
                        scale     <4,0.55,0.55>
                        rotate    <0,0,0>
                        translate <1.9,0,0>
                    }

                    // Objectname = ArachnoidLegL1Seg3
                    // Objecttype = csg (union)
                    union
                    {
                        // Objectname = ArachnoidLegL1Body3
                        // Objecttype = sphere
                        sphere
                        {
                            <0,0,0>,0.5
                            scale     <2,0.4,0.4>
                            rotate    <0,0,0>
                            translate <0.9,0,0>
                        }

                        // Objectname = ArachnoidLegL1Seg4
                        // Objecttype = csg (union)
                        union
                        {
                            // Objectname = ArachnoidLegL1Body4
                            // Objecttype = sphere
                            sphere
                            {
                                <0,0,0>,0.5
                                scale     <0.5,0.2,0.2>
                                rotate    <0,0,0>
                                translate <0.4,0,0>
                            }

                            scale     <1,1,1>
                            rotate    <0,0,0>
                            translate <1.9,0,0>
                        }
                        scale     <1,1,1>
                        rotate    <0,0,0>
                        translate <3.9,0,0>
                    }
                    scale     <1,1,1>
                    rotate    <0,0,-90>
                    translate <4.9,0,0>
                }
                scale     <0.5,0.5,0.5>
                rotate    <0,-30,45>
                translate <0,0,0>
            }
            scale     <1.1,1.1,-1.1>
            rotate    <0,-90,0>
            translate <0.5,0,0.9>
        }
        // Objectname = ArachnoidLegR2
        // Objecttype = csg (union)
        union
        {
            // Objectname = ArachnoidLegR2Seg1
            // Objecttype = csg (union)
            union
            {
                // Objectname = ArachnoidLegR2Body1
                // Objecttype = sphere
                sphere
                {
                    <0,0,0>,0.5
                    scale     <5,0.7,0.7>
                    rotate    <0,0,0>
                    translate <2.4,0,0>
                }

                // Objectname = ArachnoidLegR2Seg2
                // Objecttype = csg (union)
                union
                {
                    // Objectname = ArachnoidLegR2Body2
                    // Objecttype = sphere
                    sphere
                    {
                        <0,0,0>,0.5
                        scale     <4,0.55,0.55>
                        rotate    <0,0,0>
                        translate <1.9,0,0>
                    }

                    // Objectname = ArachnoidLegR2Seg3
                    // Objecttype = csg (union)
                    union
                    {
                        // Objectname = ArachnoidLegR2Body3
                        // Objecttype = sphere
                        sphere
                        {
                            <0,0,0>,0.5
                            scale     <2,0.4,0.4>
                            rotate    <0,0,0>
                            translate <0.9,0,0>
                        }

                        // Objectname = ArachnoidLegR2Seg4
                        // Objecttype = csg (union)
                        union
                        {
                            // Objectname = ArachnoidLegR2Body4
                            // Objecttype = sphere
                            sphere
                            {
                                <0,0,0>,0.5
                                scale     <0.5,0.2,0.2>
                                rotate    <0,0,0>
                                translate <0.4,0,0>
                            }

                            scale     <1,1,1>
                            rotate    <0,0,0>
                            translate <1.9,0,0>
                        }
                        scale     <1,1,1>
                        rotate    <0,0,0>
                        translate <3.9,0,0>
                    }
                    scale     <1,1,1>
                    rotate    <0,0,-90>
                    translate <4.9,0,0>
                }
                scale     <0.5,0.5,0.5>
                rotate    <0,0,35>
                translate <0,0,0>
            }
            scale     <1,1,1>
            rotate    <0,90,0>
            translate <0,0,-1>
        }
        // Objectname = ArachnoidLegL2
        // Objecttype = csg (union)
        union
        {
            // Objectname = ArachnoidLegL2Seg1
            // Objecttype = csg (union)
            union
            {
                // Objectname = ArachnoidLegL2Body1
                // Objecttype = sphere
                sphere
                {
                    <0,0,0>,0.5
                    scale     <5,0.7,0.7>
                    rotate    <0,0,0>
                    translate <2.4,0,0>
                }

                // Objectname = ArachnoidLegL2Seg2
                // Objecttype = csg (union)
                union
                {
                    // Objectname = ArachnoidLegL2Body2
                    // Objecttype = sphere
                    sphere
                    {
                        <0,0,0>,0.5
                        scale     <4,0.55,0.55>
                        rotate    <0,0,0>
                        translate <1.9,0,0>
                    }

                    // Objectname = ArachnoidLegL2Seg3
                    // Objecttype = csg (union)
                    union
                    {
                        // Objectname = ArachnoidLegL2Body3
                        // Objecttype = sphere
                        sphere
                        {
                            <0,0,0>,0.5
                            scale     <2,0.4,0.4>
                            rotate    <0,0,0>
                            translate <0.9,0,0>
                        }

                        // Objectname = ArachnoidLegL2Seg4
                        // Objecttype = csg (union)
                        union
                        {
                            // Objectname = ArachnoidLegL2Body4
                            // Objecttype = sphere
                            sphere
                            {
                                <0,0,0>,0.5
                                scale     <0.5,0.2,0.2>
                                rotate    <0,0,0>
                                translate <0.4,0,0>
                            }

                            scale     <1,1,1>
                            rotate    <0,0,0>
                            translate <1.9,0,0>
                        }
                        scale     <1,1,1>
                        rotate    <0,0,0>
                        translate <3.9,0,0>
                    }
                    scale     <1,1,1>
                    rotate    <0,0,-90>
                    translate <4.9,0,0>
                }
                scale     <0.5,0.5,0.5>
                rotate    <0,0,35>
                translate <0,0,0>
            }
            scale     <1,1,-1>
            rotate    <0,-90,0>
            translate <0,0,1>
        }
        // Objectname = ArachnoidLegR3
        // Objecttype = csg (union)
        union
        {
            // Objectname = ArachnoidLegR3Seg1
            // Objecttype = csg (union)
            union
            {
                // Objectname = ArachnoidLegR3Body1
                // Objecttype = sphere
                sphere
                {
                    <0,0,0>,0.5
                    scale     <5,0.7,0.7>
                    rotate    <0,0,0>
                    translate <2.4,0,0>
                }

                // Objectname = ArachnoidLegR3Seg2
                // Objecttype = csg (union)
                union
                {
                    // Objectname = ArachnoidLegR3Body2
                    // Objecttype = sphere
                    sphere
                    {
                        <0,0,0>,0.5
                        scale     <4,0.55,0.55>
                        rotate    <0,0,0>
                        translate <1.9,0,0>
                    }

                    // Objectname = ArachnoidLegR3Seg3
                    // Objecttype = csg (union)
                    union
                    {
                        // Objectname = ArachnoidLegR3Body3
                        // Objecttype = sphere
                        sphere
                        {
                            <0,0,0>,0.5
                            scale     <2,0.4,0.4>
                            rotate    <0,0,0>
                            translate <0.9,0,0>
                        }

                        // Objectname = ArachnoidLegR3Seg4
                        // Objecttype = csg (union)
                        union
                        {
                            // Objectname = ArachnoidLegR3Body4
                            // Objecttype = sphere
                            sphere
                            {
                                <0,0,0>,0.5
                                scale     <0.5,0.2,0.2>
                                rotate    <0,0,0>
                                translate <0.4,0,0>
                            }

                            scale     <1,1,1>
                            rotate    <0,0,0>
                            translate <1.9,0,0>
                        }
                        scale     <1,1,1>
                        rotate    <0,0,0>
                        translate <3.9,0,0>
                    }
                    scale     <1,1,1>
                    rotate    <0,0,-90>
                    translate <4.9,0,0>
                }
                scale     <0.5,0.5,0.5>
                rotate    <0,45,45>
                translate <0,0,0>
            }
            scale     <0.9,0.9,0.9>
            rotate    <0,90,0>
            translate <-0.5,0,-0.9>
        }
        // Objectname = ArachnoidLegL3
        // Objecttype = csg (union)
        union
        {
            // Objectname = ArachnoidLegL3Seg1
            // Objecttype = csg (union)
            union
            {
                // Objectname = ArachnoidLegL3Body1
                // Objecttype = sphere
                sphere
                {
                    <0,0,0>,0.5
                    scale     <5,0.7,0.7>
                    rotate    <0,0,0>
                    translate <2.4,0,0>
                }

                // Objectname = ArachnoidLegL3Seg2
                // Objecttype = csg (union)
                union
                {
                    // Objectname = ArachnoidLegL3Body2
                    // Objecttype = sphere
                    sphere
                    {
                        <0,0,0>,0.5
                        scale     <4,0.55,0.55>
                        rotate    <0,0,0>
                        translate <1.9,0,0>
                    }

                    // Objectname = ArachnoidLegL3Seg3
                    // Objecttype = csg (union)
                    union
                    {
                        // Objectname = ArachnoidLegL3Body3
                        // Objecttype = sphere
                        sphere
                        {
                            <0,0,0>,0.5
                            scale     <2,0.4,0.4>
                            rotate    <0,0,0>
                            translate <0.9,0,0>
                        }

                        // Objectname = ArachnoidLegL3Seg4
                        // Objecttype = csg (union)
                        union
                        {
                            // Objectname = ArachnoidLegL3Body4
                            // Objecttype = sphere
                            sphere
                            {
                                <0,0,0>,0.5
                                scale     <0.5,0.2,0.2>
                                rotate    <0,0,0>
                                translate <0.4,0,0>
                            }

                            scale     <1,1,1>
                            rotate    <0,0,0>
                            translate <1.9,0,0>
                        }
                        scale     <1,1,1>
                        rotate    <0,0,0>
                        translate <3.9,0,0>
                    }
                    scale     <1,1,1>
                    rotate    <0,0,-90>
                    translate <4.9,0,0>
                }
                scale     <0.5,0.5,0.5>
                rotate    <0,45,45>
                translate <0,0,0>
            }
            scale     <0.9,0.9,-0.9>
            rotate    <0,-90,0>
            translate <-0.5,0,0.9>
        }
        scale     <1,1,1>
        rotate    <0,0,0>
        translate <0,0,0>
    }
    // Objectname = Arachnoid1
    // Objecttype = texture
        pigment
    {
        onion
        color_map
        {
            [0 color rgbt<0,0,0,0>]
            [0 color rgbt<0,0,0,0>]
            [0 color rgbt<0,0,0,0>]
            [0 color rgbt<0,0,0,0>]
            [0 color rgbt<0,0,0,0>]
            [0 color rgbt<0,0,0,0>]
            [0.0111111 color rgbt<0.705882,0.466667,0.0588235,0>]
            [0.403704 color rgbt<0.501961,0,0,0>]
            [0.911111 color rgbt<0.501961,0,0,0>]
        }
        turbulence 4

    }
    finish
    {
        ambient          rgb<0,0,0>
        diffuse          0.7
        brilliance       1
        phong            0
        phong_size       40
        specular         0
        roughness        0.05
        reflection       rgb<0,0,0>
        refraction       0
        ior              0
        caustics         0
//        fade_distance    1
//        fade_power       1
        crand            0

    }
    scale     <1,1,1>
    rotate    <0,0,0>
    translate <0,0,0>
}
// Objectname = Lightpoint
// Objecttype = lightpoint
light_source
{
    <0, 0, 0>
    color rgb<1.000000, 1.000000, 1.000000> 
    fade_distance 13
    fade_power 1
    scale     <1,1,1>
    rotate    <0,0,0>
    translate <0,2,2>
}

// Objectname = Lightpoint1
// Objecttype = lightpoint
light_source
{
    <0, 0, 0>
    color rgb<1.000000, 1.000000, 1.000000> 
    fade_distance 15
    fade_power 1
        scale     <1,1,1>
    rotate    <0,0,0>
    translate <0,-2,-2>
}

