#ifndef _CardTable_
#define _CardTable_

#include <qwidget.h>
#include <qkeycode.h>
#include <QwSpriteField.h>

#include "SolQwImageSpriteField.h"
#include "BaseCard.h"

enum MouseActionType { msNone, msClick, msDoubleClick, msDrag};
enum MouseButton { Left, Middle, Right };             

class CardTable : public QWidget {   
  Q_OBJECT;
public:

  CardTable(int width, int height, QWidget* parent=0, const char* name=0, WFlags f=0);  
  bool setBackground(const char* filename);

protected:
  bool eventFilter(QObject*, QEvent*);
  void timerEvent(QTimerEvent *);
  void resizeEvent(QResizeEvent*); 

  /* The following psuedo-events will be called from the eventFilter. */
  virtual bool startDragEvent(BaseCard *card)=0;
  virtual bool dragEvent(BaseCard *card, int nx, int ny)=0;
  virtual void preDropEvent(BaseCard *card)=0;
  virtual bool dropEvent(BaseCard *card, BaseCard *drop_on_card)=0;
  virtual void dropFailedEvent(BaseCard *card)=0;
  virtual void clickEvent(BaseCard *card, int nx, int ny, int button)=0;
  virtual void doubleClickEvent(BaseCard *card, int nx, int ny, int button)=0;

private:
  SolQwImageSpriteField field;  
  QwSpriteFieldView view;
  BaseCard* drag_card;
  MouseActionType msAction;
  QMouseEvent *mouseEv;
  int msActionX, msActionY;
}; 

#endif

