#ifndef STATUS_H
#define STATUS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>

#include <qwidget.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qarray.h>
#include <qlist.h>
#include <qregexp.h>

class Status : public QWidget
{
    Q_OBJECT
public:
    Status(QWidget *parent=0, const char *name=0, QString pixDir=0);
    ~Status() {};

public slots:
    void setLifes(int lifes);
    void setLevel(int level);

    void setPixmaps(QString pixDir=0);

protected:
    QList<QPixmap> *loadPixmap(QWidget *parent, QString pixmapName, QList<QPixmap> *pixmaps=0);
    void  paintEvent(QPaintEvent *);
    int minHeight();
    int minWidth();
    void Status::fillArray(QArray<int> &, QString, int);

private:
    int maxLevel;
    QList<QPixmap> *lifesPix;
    QList<QPixmap> *levelPix;
    QArray<int> levelPos;
    int actualLifes;
    int actualLevel;
};

#endif // STATUS_H

