/* zone_board.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef ZONE_BOARD_H
#define ZONE_BOARD_H

#include <qobject.h>
#include <qsignal.h>
//#include <qarray.h>
//#include <qpntarry.h>
#include "go_board.h" 

/**
 * This class can be used for determining the zones
 * of a KGoBoard when the game has been finished.
 * This functionality could also be implemented in KGoBoard,
 * but this hasn't been done to keep KGoBoard smaller.
 *
 * @short Class for determinig zones. 
 */
class KZoneBoard : public QObject
{
	Q_OBJECT

public:
	KZoneBoard( KGoBoard*, QObject *parent=0 ) ;
	~KZoneBoard();

	void determineZones() ;
	void removeDead( int, int ) ;
	int get( int, int ) ;

	/**
	 * Get the board with the zones.
	 *
	 * @return a pointer to the internal board
	 */
	unsigned char** getResult() ;

protected:
	void set(int, int, int, bool redraw=true ) ;
	void remove( int, int, bool redraw=true ) ;
	
	void removeDeadNeighbours( int, int, int ) ;
	void findZones() ;

	/**
	 * Find a region and fill the region[][] structure
	 *
	 * @return true if a region was found
	 */
	bool findRegion( int, int ) ;
	void addRegionElements( int x, int y ) ;
	void tryAddElement(int x, int y ) ;
	void fillRegion() ; 

	bool inRange( int x, int y ) ;

	KGoBoard *board ;
	int xWidth, yWidth ;
	unsigned char **zones ;
	unsigned char **region ;
} ;

#endif
