/* view_2player.cpp
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#include <qobject.h>
#include <qwidget.h>
#include <qsignal.h>
#include "go_board.h"
#include "go_player.h"
#include "dummy_player.h"
#include "view_2player.moc"

KView2Player::KView2Player( KGoBoard *b, QWidget *parent,
		const char *name )
 	: KGoView( b, parent, name )
{
	white = new KV2P_Player( this, WHITE, b, 0, name ) ;
	black = new KV2P_Player( this, WHITE, b, 0, name ) ;
	inf = new QLabel( "Two player game", this, "inf" ) ;
	passb = new QPushButton( "Pass", this, "pass" ) ;

	connect( this, SIGNAL( positionLeftClicked(int, int)),
			this, SLOT( generateMove(int,int)) ) ;
//	connect( black, SIGNAL( notifyOpponentMoved(int,int) ),
//			this, SLOT( receiveMove(int,int)) ) ;
	connect( passb, SIGNAL( clicked()),
			this, SLOT(pass()) ) ;
	// this connect also catched the black illegal moves
	connect( white, SIGNAL( notifyIllegalMove(int,int)),
		this, SLOT( receiveIllegalMove(int,int)) ) ;
}

KView2Player::~KView2Player()
{
	// note: we don't delete white & black
	// this should be done in the KGoWidget
	delete inf ;
	delete passb ;
}

void KView2Player::receiveIllegalMove( int r, int p )
{
	QString c = 0 ;
	if ( p == WHITE )
	{
		c = klocale->translate("White") ;
	}
	else	c = klocale->translate("Black") ;

	QString tmp ;
	tmp.sprintf( "%s %s %s",
			c.data(),
			klocale->translate("made an illegal move:"),
			KGoBoard::getIllegalMoveReason( r ).data()
		) ;
	info( tmp.data() ) ;
}

void KView2Player::info( const char *s )
{
	info_label->setText( s ) ;
}

KGoPlayer* KView2Player::getWhitePlayer()
{
	return white ;
}

KGoPlayer* KView2Player::getBlackPlayer()
{
	return black ;
}

int KView2Player::playerToMove()
{	
	return white->playerToMove() ; 
}

void KView2Player::pass()
{
	generateMove( PASS, PASS ) ;
}

void KView2Player::generateMove( int x, int y )
{
	if ( playerToMove()==WHITE )
	{
		white->playMove( x, y ) ;
	}  
	else	black->playMove( x, y ) ;  
} 

void KView2Player::receiveMove( int x, int y, int p )
{
	KGoView::receiveMove( x, y, p ) ;

	redraw() ;
}

void KView2Player::resizeEvent( QResizeEvent * )
{
	QSize s = size() ;

	inf->setGeometry( 10, 10, s.width()-70, 20 ) ;
	passb->setGeometry( s.width()-60, 10, 50, 20 ) ;

	QRect r = QRect( 0, 50, s.width(), s.height() - 50 ) ;

	this->KGoView::resizeEvent( r ) ;
}

