/* knetobject.cpp
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#include <qobject.h>
#include <qsignal.h>
#include <qevent.h>

#include <unistd.h>
#include <stdio.h>

#include "knetobject.moc"

KNetObject::KNetObject( KSocket *s ) : QObject(0),
	in_message_begin(0), in_message_end(0),
	out_message_begin(0), out_message_end(0)
{
	ksocket = s ;

	if ( ksocket!=0 )
	{
		connect( ksocket, SIGNAL(readEvent(KSocket*)),
				SLOT(receiveReadEvent(KSocket*)) ) ;
		connect( ksocket, SIGNAL(writeEvent(KSocket*)),
				SLOT(receiveWriteEvent(KSocket*)) ) ;
		connect( ksocket, SIGNAL(closeEvent(KSocket*)),
				SLOT(receiveCloseEvent(KSocket*)) ) ;
	}
	else
	{
		debug("KNetObject - got null socket") ;
	}

	fd = ksocket->socket() ;
	ksocket->enableRead( true ) ;

	#ifdef DEBUG
	printf("netobject: %p, fd %d\n", this, fd ) ;
	#endif
}

KNetObject::~KNetObject()
{
}

bool KNetObject::sendMessage( char *s )
{
	#ifdef DEBUG
	printf("sendMessage %p\n", this ) ;
	#endif

	if ( outBufferFull() )
	{
		debug("outgoing message buffer is full") ;
		return false ;
	}
	else
	{
		strncpy( out_buf[out_message_end],
			s, MAX_MESSAGE_SIZE ) ;
		if( out_message_end==BUFFER_SIZE-1 )
			out_message_end = 0 ;
		else	out_message_end++ ;

		ksocket->enableWrite( true ) ;
		printf("%p placed message in buffer : b %d e %d\n", 
			this,	out_message_begin, out_message_end);
		return true ;
	}
}

char * KNetObject::getMessage()
{
	#ifdef DEBUG
	printf("getMessage %p\n", this ) ;
	#endif

	if ( ! inBufferEmpty() )
	{
		char *s = new char[MAX_MESSAGE_SIZE] ;
		strncpy( s, in_buf[in_message_begin], MAX_MESSAGE_SIZE) ;
		if( in_message_begin==BUFFER_SIZE-1 )
			in_message_begin = 0 ;
		else	in_message_begin++ ;

		ksocket->enableRead( true ) ;
		return s ;
	}
	else
	{
		printf("no messages in incoming buffer") ;
		ksocket->enableRead( true ) ;
 		return 0 ;
	}
}

bool KNetObject::isMessageWaiting()
{
	return ! inBufferEmpty() ;
}

bool KNetObject::inBufferEmpty()
{
	return in_message_begin==in_message_end ;
}

bool KNetObject::outBufferEmpty()
{
	return out_message_begin==out_message_end ;
}

bool KNetObject::inBufferFull()
{
	int i = in_message_end+1+BUFFER_SIZE ;
	i -= in_message_begin ;

	return (i%BUFFER_SIZE)==0 ;
}
bool KNetObject::outBufferFull()
{
	int i = out_message_end+1+BUFFER_SIZE ;
	i -= out_message_begin ;

	return (i%BUFFER_SIZE)==0 ;
}

void KNetObject::receiveReadEvent( KSocket* )
{
	#ifdef DEBUG
	printf("receiveReadEvent %p\n", this ) ;
	#endif

	//ksocket->enableRead( false ) ;

	if( ! inBufferFull() ) 
	{
		int status ;
		status = read( fd, in_buf[in_message_end], MAX_MESSAGE_SIZE ) ;

		// check status
		if ( status==-1 )
			debug("error") ;
	
		if ( status > 0 )
		{
			if( in_message_end==BUFFER_SIZE-1 )
				in_message_end = 0 ;
			else	in_message_end++ ;
			emit messageArrived() ;
		}
	}
	else
	{
		debug("incoming-message buffer is full") ;
	}

	if ( ! inBufferFull() )
		ksocket->enableRead( true ) ;
	else	debug("in buffer full %p\n", this ) ; 
}

void KNetObject::receiveWriteEvent( KSocket* )
{
	#ifdef DEBUG
	printf("receiveWriteEvent %p\n", this ) ;
	#endif

	ksocket->enableWrite( false ) ;

	int status ;
	status = write( fd, out_buf[out_message_begin], MAX_MESSAGE_SIZE ) ;

	if( out_message_begin==BUFFER_SIZE-1 )
		out_message_begin = 0 ;
	else	out_message_begin++ ;

	if ( status==-1 )
	{
		debug("error: message could not be send") ;
		// exit(0) ;
	}
	else
	{
		// message was sent correctly
		if( ! outBufferEmpty() )
			ksocket->enableWrite( true ) ;		
	}
}

void KNetObject::receiveCloseEvent( KSocket* )
{
	delete ksocket ;
	ksocket=0 ;
	printf("KNetObject - the connection was broken\n") ;
	emit connectionBroken() ;
	delete this ;
}



