/* KMoveList.h
 *
 * Pieter Eendebak <pte@ddsw.nl>
 */

#ifndef MOVE_LIST_H
#define MOVE_LIST_H


#include <qtablevw.h>

/**
 * KMoveList is a class designed for showing a list of Go moves.
 */
class KMoveList : public QTableView
{
	Q_OBJECT

public:
	/**
	 * KMoveList is a class for showing
	 * a list of strings. The class was written
	 * to show a list of go-moves that scrolls
	 * when the game goes on.
	 *
	 */
	KMoveList( int rows,
		QWidget* parent=0, const char* name=0 );
	~KMoveList();

	/**
	 * Add a new move to the list.
	 */
	void addMove( QString ) ;
	void addMoveWhite( QString ) ;
	void addMoveBlack( QString ) ;

	/**
	 * Remove add data
	 */
	void removeAllMoves() ;

	/**
	 * A KMoveList always has 2 columns and a variable
	 * number of rows.
	 * 
	 * @return the number of rows for this list
	 */
	int sizeOfList() ;

protected:

	int cellWidth(int) ;
	int cellHeight(int) ;

	/**
	 * @return contents of a cell
	 */
	const char* cell( int row, int col ) ;

	/**
	 * Set content of a cell
	 */
	void setCell( int row, int col, QString ) ;

	/**
	 * Draw a cell for the widget
	 */
	void paintCell( QPainter*, int row, int col ) ;

  
private:
	int indexOf( int row ) ;
	void switchColor() ;

	QString **contents;
	// number of rows (always 2 columns) 
	int rows ;
	// where to append new data 
	int add_after ;
	// cycle through the table
	int offset ;

	int color_to_add ;
};

#endif

