#!/bin/sh
#
#
#
#

flist="enemies/enemy_1.ppm enemies/enemy_2.ppm enemies/enemy_3.ppm enemies/enemy_4.ppm"


ppm2pbm()
{
  bnameP=$1
  bname=`basename $bnameP .ppm`
  bnameM="$bname.pbm"
  echo "$bnameP $bname.m.ppm $bnameM"
  combine -compose xor $bnameP  mask.ppm  tmp.ppm
  combine -compose minus tmp.ppm $bnameP $bname.m.ppm
  convert $bname.m.ppm $bnameM
  rm tmp.ppm
  rm $bname.m.ppm
}



for f in $flist
do
  bname=`basename $f .ppm`
  degStep=10
  deg=0
  nr=0
  while [ $deg -lt 360 ]
  do
    cp $f abcdefgh

    #
    # Filenames: mask and pic
    #
    bnameM=`printf %s.%d.pbm $bname $nr`
    bnameP=`printf %s.%d.ppm $bname $nr`
 
    #
    #create rotated picfile
    #
    ##mogrify -blur 10.0 -rotate $deg $f 
    mogrify -rotate $deg $f 
    
    #
    #create maskfile from picfile
    #
    combine -compose xor $f mask.ppm  abcdefgh.ppm
    combine -compose minus abcdefgh.ppm $f $bname.$nr.m.ppm
    convert $bname.$nr.m.ppm $bnameM
    rm $bname.$nr.m.ppm
    cp $f $bnameP
    
    #
    # set values and restore original pic
    #
    cp abcdefgh $f 
    deg=`expr $deg + $degStep`
    nr=`expr $nr + 1`

  done
done

cp background/*.ppm .

cp destroy/*.ppm .
for f in `ls dest*.ppm`
do
 ppm2pbm $f
done

cp player/*.ppm .
for f in `ls player*.ppm`
do
 ppm2pbm $f
done


cp shots/*.ppm .
for f in `ls *shot*.ppm`
do
  ppm2pbm $f
done



