/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   
#ifndef LEVELGENDIALOG_H
#define LEVELGENDIALOG_H

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <qdialog.h>
#include <qlist.h>
#include <qlabel.h> 
#include <qchkbox.h>
#include <qpixmap.h>
#include <kdbtn.h> 

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/
struct enemyListEntry
{
  QPixmap pic;
  int     enemytype;
};


class levelItem: public QObject
{
  Q_OBJECT
  
  public:
    levelItem( QWidget *parent, QList<enemyListEntry> enemyEntries, int x, int y );
    ~levelItem();
    int xpos, ypos;
    
  public slots:
    void leftArrowClicked();
    void rightArrowClicked();
    enemyListEntry *getCurrent();
    void clearEnemy();
    
  private:
    KDirectionButton *leftBtn, *rightBtn;
    QLabel *picBtn;
    QList<enemyListEntry> enemyList;
    
};


class levelGenDialog: public QDialog
{
  Q_OBJECT

  public:
    levelGenDialog( QString enemyPath );
    ~levelGenDialog();
    
  public slots:
    virtual void cancelBtnClicked();
    virtual void okBtnClicked();
    virtual void helpBtnClicked();
    virtual void clearBoxes();
    
//  signals:

  private:
    QList<levelItem> levelItemList;
    QList<enemyListEntry> enemyList;
  
  protected:
};


#endif // LEVELGENDIALOG_H



