#include "Settings.h"

#include <qlayout.h>
#include <kapp.h>

Settings::Settings (int _sizeX, int _sizeY, int _sizeZ, int _startingLevel,
		    QWidget *parent, const char *name) : QWidget (parent, name)
{
	QGridLayout *l=new QGridLayout (this, 4, 2, 5, 5);
	
	sizeX=new KIntegerLine (this);
	sizeX->setValue (_sizeX);
	l->addWidget (new QLabel (kapp->klocale->translate ("Size X"), this), 0, 0);
	l->addWidget (sizeX, 0, 1);
	
	sizeY=new KIntegerLine (this);
	sizeY->setValue (_sizeY);
	l->addWidget (new QLabel (kapp->klocale->translate ("Size Y:"), this), 1, 0);
	l->addWidget (sizeY, 1, 1);

	sizeZ=new KIntegerLine (this);
	sizeZ->setValue (_sizeZ);
	l->addWidget (new QLabel (kapp->klocale->translate ("Size Z:"), this), 2, 0);
	l->addWidget (sizeZ, 2, 1);

	startingLevel=new KIntegerLine (this);
	startingLevel->setValue (_startingLevel);
	l->addWidget (new QLabel (kapp->klocale->translate ("Starting Level:"), this), 3, 0);
	l->addWidget (startingLevel, 3, 1);
	l->activate();
}

// Local Variables:
// compile-command: "make Settings.o"
// End:
