/***************************************************************************
                 QueryDlg.cpp  -  dialog when in query mode
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "QueryDlg.h"
#include "resource.h"
#include "kvoctraindoc.h"
#include "QueryManager.h"
#include "ProgressChart.h"
#include "kvoctrain.h"
#include "rowtable.h"

#include <kapp.h> 

#include <qtimer.h>
#include <qdialog.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qkeycode.h>
#include <qpainter.h>

#include <iostream.h>

#include "compat_2x.h"

QueryDlg::QueryDlg(QString org,
                   QString trans,
                   int entry,
                   int orgcol,
                   int transcol,
                   int q_cycle,
                   int q_num,
                   int q_start,
                   kvoctrainExpr *exp,
                   kvoctrainApp  *app,
                   kvoctrainDoc  *doc,
                   int mqtime,
                   QWidget *parent,
                   char *name)
	: QueryDlgData(parent,name)
{
        kv_doc = 0;
        qtimer = 0;
	setCaption (QString(KVOCTRAIN_TITLE) + ": " + i18n("Random query"));
        setQuery (org, trans, entry, orgcol, transcol,
                  q_cycle, q_num, q_start,
                  exp, app, doc, mqtime);
        setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


void QueryDlg::	setQuery(QString org,
                         QString trans,
                         int entry,
                         int orgcol,
                         int transcol,
                         int q_cycle,
                         int q_num,
                         int q_start,
                         kvoctrainExpr *exp,
                         kvoctrainApp  *_app,
                         kvoctrainDoc  *,
                         int mqtime)
{
   kv_app = _app;
//   kv_doc = doc;
   q_row = entry;
   q_ocol = orgcol;
   q_tcol = transcol;
   translation = trans;
   showCounter = 0;
   transField->setText ("");
   orgField->setText (org);
   show_all->setDefault(true);
   QString s;
   s.setNum (q_cycle);
   progCount->setText (s);
   remark->setText (exp->getRemark(orgcol));
   falseFriend->setText (exp->getFauxAmi(orgcol, orgcol!=0));
   progChart->setData (q_start, q_num);
   progChart->repaint();

   type->setText ("");
   vector<TypeRelation> all_types = QueryManager::getRelation(false);
   for (int i = 0; i < (int) all_types.size(); i++) {
     if ( exp->getType(orgcol) == all_types[i].shortStr())
       type->setText(all_types[i].longStr());
   }

   if (mqtime >= 1000) { // more than 1000 milli-seconds
     if (qtimer == 0)
       qtimer = new QTimer( this );
     connect( qtimer, SIGNAL(timeout()), this, SLOT(timeoutReached()) );
     qtimer->start(mqtime, TRUE);
   }
   resetField (transField);
}


void QueryDlg::initFocus() const
{
  transField->setFocus();
}


void QueryDlg::optionsClicked()
{
   emit sigOptions();
}


void QueryDlg::verifyClicked()
{
  if (verifyField (transField, translation))
    know_it->setDefault(true);
  else
    dont_know->setDefault(true);
}


void QueryDlg::showMoreClicked()
{
  resetField (transField);
  if (showCounter < (int)translation.length() ) {
    transField->setText (translation.left(++showCounter));
    dont_know->setDefault(true);
  }

}


void QueryDlg::showAllClicked()
{
  resetField (transField);
  transField->setText (translation);
  dont_know->setDefault(true);
}


void QueryDlg::slotTransChanged(EA_QTSTR)
{
  resetField (transField);
}


void QueryDlg::knowItClicked()
{
   done (QueryDlg::Known);
}


void QueryDlg::timeoutReached()
{
   done (QueryDlg::Timeout);
}


void QueryDlg::dontKnowClicked()
{
   done (QueryDlg::Unknown);
}


void QueryDlg::stopItClicked()
{
   done (QueryDlg::StopIt);
}


void QueryDlg::editOrgClicked()
{

   if (qtimer != 0)
     qtimer->stop();

   emit sigEditEntry (q_row, KV_COL_ORG+q_ocol);
}


void QueryDlg::editTransClicked()
{

   if (qtimer != 0)
     qtimer->stop();

   emit sigEditEntry (q_row, KV_COL_ORG+q_tcol);
}


void QueryDlg::keyPressEvent( QKeyEvent *e )
{
  switch( e->key() )
  {
    case Key_Escape:
      dontKnowClicked();
    break;
      
    case Key_Return:
    case Key_Enter:
      if (dont_know->isDefault() )
        dontKnowClicked();
      else if (know_it->isDefault() )
        knowItClicked();
      else if (show_all->isDefault() )
        showAllClicked();
    break;
      
    default:
      e->ignore();
    break;
  }
}

