/***************************************************************************
              EntryDlg.cpp  -  entry dialog for table cell contents
                             -------------------
    begin                : Thu Mar 11 20:50:53 MET 1999

    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "EntryDlg.h"

#define Inherited QTabDialog

#include <iostream.h>
#include <kapp.h>

#include "kvoctraindoc.h"
#include "resource.h"
#include "langset.h"

#include "compat_2x.h"

EntryDlg::EntryDlg
(
        kvoctrainDoc *doc,
        bool        multi_sel,
        bool        origin,
        grade_t     f_grd,
        grade_t     t_grd,
        count_t     f_qcount,
        count_t     t_qcount,
        count_t     f_bcount,
        count_t     t_bcount,
        time_t      f_qdate,
        time_t      t_qdate,
        QString     f_faux_ami,
        QString     t_faux_ami,
        QString     expr,
        int         lesson,
        QComboBox  *lessonbox,
        QString     lang,
        LangSet    &langset,
        QString     rem,
        QString     type,
        QString     pronunce,
        QString     synonym,
        QString     antonym,
        QString     example,
        const       Conjugation &con_prefix,
        const       Conjugation &conjugations,
        const       Article &article,
        const       Comparison &comp,
	QWidget    *parent,
	const char *name
)
	:
	Inherited( parent, name, true )
{
	setCaption (QString(KVOCTRAIN_TITLE) + ": " + name);

        QString s;
        if (langset.findLongId(lang).isEmpty() )
          s = lang;
        else          
          s = langset.findLongId(lang);

        if (origin) {
          from_page = 0;
          to_page = 0;
          comm_page = new CommonEntryPage (this, doc, multi_sel, expr, lesson, lessonbox,
                                           lang, rem, type, pronunce, example,
                                           i18n("Original &expression in ")+s);
          aux_page = new AuxInfoEntryPage (this, multi_sel, synonym, antonym);
          tense_page = new TenseEntryPage (this, multi_sel, con_prefix, conjugations, 0, _EntryDlg_CONJUGATION);
          adj_page = new AdjEntryPage (this, multi_sel, comp, 0, _EntryDlg_ADJECTIVE);
        }
        else {
          comm_page = new CommonEntryPage (this, doc, multi_sel, expr, lesson, lessonbox,
                                           lang, rem, type, pronunce, example,
                                           i18n("Translated &expression in ")+s);
          aux_page = new AuxInfoEntryPage (this, multi_sel, synonym, antonym);
          tense_page = new TenseEntryPage (this, multi_sel, con_prefix, conjugations, 0, _EntryDlg_CONJUGATION);
          adj_page = new AdjEntryPage (this, multi_sel, comp, 0, _EntryDlg_ADJECTIVE);
          from_page = new FromToEntryPage (this, multi_sel, f_grd, f_qdate, f_qcount, f_bcount,
                                           f_faux_ami,
                                           i18n("Properties from original"));
          to_page   = new FromToEntryPage (this, multi_sel, t_grd, t_qdate, t_qcount, t_bcount,
                                           t_faux_ami,
                                           i18n("Properties to original"));
        }

        setCancelButton();
          
        addTab( comm_page,  i18n( "&Common" ));
        addTab( aux_page,   i18n( "&Additional" ));
        addTab( tense_page, _EntryDlg_CONJUGATION);
        addTab( adj_page,   _EntryDlg_ADJECTIVE);
        if (!origin) {
          addTab( from_page, i18n( "&From original" ));
          addTab( to_page, i18n( "&To original" ));
        }
      
        updatePages (type);

        connect(comm_page, SIGNAL(typeSelected(const QString&)),
                SLOT(updatePages(const QString&)) );

        connect( this, SIGNAL(applyButtonPressed()), SLOT(accept()) );
        connect( this, SIGNAL(cancelButtonPressed()), SLOT(reject()) );

        connect (this, SIGNAL(aboutToShow()), comm_page, SLOT(initFocus() ));
        connect (this, SIGNAL(aboutToShow()), aux_page, SLOT(initFocus() ));
        connect (this, SIGNAL(aboutToShow()), tense_page, SLOT(initFocus() ));
        connect (this, SIGNAL(aboutToShow()), from_page, SLOT(initFocus() ));
        connect (this, SIGNAL(aboutToShow()), to_page, SLOT(initFocus() ));

        resize( 600+16,410+76 );
        setMinimumSize( 600+16,410+76 );
        setMaximumSize( 600+16,410+76 );

        setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


void EntryDlg::updatePages(const QString &type)
{
   QString main;
   int pos;
   if ((pos = type.find (QM_TYPE_DIV)) < 0)  // only use main type
     main = type;
   else
     main = type.left(pos);

//   cout << "type " << main << endl;

   if (main == QM_VERB) {
     setTabEnabled (_EntryDlg_CONJUGATION, true);
     setTabEnabled (_EntryDlg_ADJECTIVE, false);
   }                  
   else if (main == QM_ADJ) {
     setTabEnabled (_EntryDlg_CONJUGATION, false);
     setTabEnabled (_EntryDlg_ADJECTIVE, true);
   }
   else {
     setTabEnabled (_EntryDlg_CONJUGATION, false);
     setTabEnabled (_EntryDlg_ADJECTIVE, false);
   }
}


EntryDlg::~EntryDlg()
{
}

