/***************************************************************************
                      DocPropDlg.cpp  -  options dialog class
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "DocPropDlg.h"
#include "DocOptionsPage.h"
#include "resource.h"
#include "rowtable.h"
#include "kvoctraindoc.h"
#include "langset.h"
#include "TitlePage.h"
#include "TypeOptPage.h"
#include "LangPropPage.h"

#include <kapp.h>
#include <qcombobox.h>

#define Inherited QTabDialog

#include "compat_2x.h"

class kvoctraindoc;

DocPropsDlg::DocPropsDlg
(
        kvoctrainDoc    *doc,
        const char      *start_page,
        QComboBox       *lessons,
        QString          title,
        QString          author,
        vector<QString>  types,
        LangSet         *langset,
	QWidget         *parent,
	const char      *name
)
	:
	Inherited( parent, name, true )
{
  setCaption( QString(KVOCTRAIN_TITLE) + i18n(": Document properties") );

  lessOptPage = new LessOptPage (lessons, doc, this, name);
  titleOptPage = new TitlePage (title, author, this, name);
  typeOptPage = new TypeOptPage (types, doc, this, name);
  docOptPage = new DocOptionsPage (doc->isAllowedSorting(), this, name);

  vector<QString> tabs;
  addTab( titleOptPage, _DocDlg_TITLE );
  tabs.push_back(_DocDlg_TITLE);
  connect (this, SIGNAL(aboutToShow()), titleOptPage, SLOT(initFocus() ));

  addTab( lessOptPage, _DocDlg_LESSONS);
  tabs.push_back(_DocDlg_LESSONS);
  connect (this, SIGNAL(aboutToShow()), lessOptPage, SLOT(initFocus() ));

  addTab( typeOptPage, _DocDlg_TYPES);
  tabs.push_back(_DocDlg_TYPES );
  connect (this, SIGNAL(aboutToShow()), typeOptPage, SLOT(initFocus() ));

  addTab( docOptPage, _DocDlg_OPTIONS);
  tabs.push_back(_DocDlg_OPTIONS );
  connect (this, SIGNAL(aboutToShow()), docOptPage, SLOT(initFocus() ));

  vector<QString> own_tabs;
  for (int i = 0; i < (int) doc->numLangs(); i++) {
    QString s;
    if (i == 0)
      s = doc->getOriginalIdent();
    else
      s = doc->getIdent(i);
    LangPropPage* lpp = new LangPropPage (doc, s,
                                          doc->getConjugation(i),
                                          doc->getArticle(i));
    connect (this, SIGNAL(aboutToShow()), lpp, SLOT(initFocus() ));

    langPages.push_back (lpp);
    int idx = langset->indexShortId(s);

    if (idx >= 0) {
      own_tabs.push_back (langset->longId(idx));
    }
    else {
      own_tabs.push_back (s);
    }
  }

  int accel;
  for (int i = 0; i < (int) own_tabs.size(); i++) {
    QString s = own_tabs[i];
    if (RowTable::createMenuNames(tabs, own_tabs, i, accel))
      s.insert (accel, "&");
    addTab (langPages[i], s);
  }
/*
  if (start_page != 0) {
    if (start_page == _DocDlg_TYPES)
      showPage (typeOptPage);
    else if (start_page == _DocDlg_LESSONS)
      showPage (lessOptPage);
  }
*/

  setCancelButton();

  connect( this, SIGNAL(applyButtonPressed()), SLOT(okButton()) );
  connect( this, SIGNAL(cancelButtonPressed()), SLOT(cancelButton()) );

  resize( 600+16,290+76 );
  setMinimumSize( 600+16,290+76 );
  setMaximumSize( 600+16,290+76 );
  setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


Conjugation DocPropsDlg::getConjugation(int idx) const
{
   if (idx < (int) langPages.size() )
     return langPages[idx]->getConjugation();
   else
     return Conjugation();
}


Article DocPropsDlg::getArticle(int idx) const
{
   if (idx < (int) langPages.size() )
     return langPages[idx]->getArticle();
   else
     return Article();
}


DocPropsDlg::~DocPropsDlg()
{
}


void DocPropsDlg::cancelButton()
{
  emit reject();
}


void DocPropsDlg::okButton()
{
  emit accept();
}

