/***************************************************************************
                  VerbQueryDlg.h  -  query dialog for verbs
                             -------------------
    begin                : Fri Dec 3 18:28:18 1999

    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef VerbQueryDlg_included
#define VerbQueryDlg_included

#include "VerbQueryDlgData.h"
#include "GrammerManager.h"

class VerbQueryDlg : public VerbQueryDlgData
{
    Q_OBJECT

public:

	VerbQueryDlg(QString type,
                     int entry,
                     int col,
                     int query_cycle,
                     int query_num,
                     int query_startnum,
                     kvoctrainExpr *exp,
                     kvoctrainApp  *kv_app,
                     kvoctrainDoc  *doc,
                     const Conjugation &prefix,
                     const Conjugation &conjug,
                     int   mtime,
                     QWidget *parent=0,
                     char    *name=0);

	virtual void setQuery(QString type,
                      int entry,
                      int col,
                      int query_cycle,
                      int query_num,
                      int query_startnum,
                      kvoctrainExpr *exp,
                      kvoctrainApp  *kv_app,
                      kvoctrainDoc  *doc,
                      const Conjugation &prefix,
                      const Conjugation &conjug,
                      int   mtime);

    virtual ~VerbQueryDlg();

public slots:
    virtual void initFocus() const;

protected:
    bool next();
    void keyPressEvent( QKeyEvent *e );
    void resetAllFields();

protected slots:

    virtual void editClicked();
    virtual void stopItClicked();
    virtual void slotP3pfChanged(EA_QTSTR);
    virtual void slotP3snChanged(EA_QTSTR);
    virtual void showAllClicked();
    virtual void slotReturnPressed();
    virtual void slotP3smChanged(EA_QTSTR);
    virtual void knowItClicked();
    virtual void dontKnowClicked();
    virtual void slotP3pnChanged(EA_QTSTR);
    virtual void optionsClicked();
    virtual void slotP3sfChanged(EA_QTSTR);
    virtual void slotP1sChanged(EA_QTSTR);
    virtual void slotP2sChanged(EA_QTSTR);
    virtual void slotP3pmChanged(EA_QTSTR);
    virtual void slotP1pChanged(EA_QTSTR);
    virtual void slotP2pChanged(EA_QTSTR);
    virtual void verifyClicked();
    virtual void timeoutReached();

protected:
    int         current;
    Conjugation conjugations;
    bool        all_known;
    int         query_time;
};
#endif // VerbQueryDlg_included
