/***************************************************************************
                     langset.cpp  -  properties for a language
                             -------------------                                         
    begin                : Wed Jun 30 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "langset.h"
#include <iostream.h>

void LangSet::addSet (QString _shortId, QString _longId, QString _PixMapFile)
{
  LangDef def;
  def.shortId = _shortId;
  def.shortId2 = "";
  def.longId = _longId;
  def.PixMapFile = _PixMapFile;
  langs.push_back (def);
}


void LangSet::addSet (QString _shortId, QString _shortId2, QString _longId, QString _PixMapFile)
{
  LangDef def;
  def.shortId = _shortId;
  def.shortId2 = _shortId2;
  def.longId = _longId;
  def.PixMapFile = _PixMapFile;
  langs.push_back (def);
}


void LangSet::erase (int idx)
{
   langs.erase (&langs[idx], &langs[idx+1]);
}


QString LangSet::shortId (int index) const
{
  if (index < (int) langs.size() )
    return langs[index].shortId;

  return "";
}


QString LangSet::shortId2 (int index) const
{
  if (index < (int) langs.size() )
    return langs[index].shortId2;

  return "";
}


QString LangSet::longId (int index) const
{
  if (index < (int) langs.size() )
    return langs[index].longId;

  return "";
}


QString LangSet::PixMapFile (int index) const
{
  if (index < (int) langs.size() )
    return langs[index].PixMapFile;
  return "";
}


QString LangSet::findShortId (const QString &_longId) const
{
  for (int i = 0; i < (int) langs.size(); i++ )
    if (_longId == langs[i].longId)
      return langs[i].shortId;

  return "";
}


QString LangSet::findLongId (const QString &_shortId) const
{
  for (int i = 0; i < (int) langs.size(); i++ )
    if (   _shortId == langs[i].shortId
        || _shortId == langs[i].shortId2)
      return langs[i].longId;

  return "";
}


int LangSet::indexShortId (QString _shortId) const
{
   for (int i = 0; i < (int) langs.size(); i++) {
     if (  langs[i].shortId == _shortId
         ||langs[i].shortId2 == _shortId )
       return i;
   }
   return -1;
}


int LangSet::indexLongId (QString _longId) const
{
   for (int i = 0; i < (int) langs.size(); i++) {
     if (langs[i].longId == _longId)
       return i;
   }
   return -1;
}


int LangSet::indexPixMapFile (QString PixMapFile) const
{
   int id = -1;
   for (int i = 0; i < (int) langs.size(); i++)
     if (langs[i].PixMapFile == PixMapFile)
       id = i;
   return id;
}

int LangSet::setShortId (QString s, int index)
{
  if (index < (int) langs.size() )
    langs[index].shortId = s;
}


int LangSet::setShortId2 (QString s, int index)
{
  if (index < (int) langs.size() )
    langs[index].shortId2 = s;
}


int LangSet::setLongId (QString s, int index)
{
  if (index < (int) langs.size() )
    langs[index].longId = s;
}


int LangSet::setPixMapFile (QString s, int index)
{
  if (index < (int) langs.size() )
    langs[index].PixMapFile = s;
}

