/***************************************************************************
                  CommonEntryPage.cpp  -- edit common properties
                             -------------------                                         
    begin                : Mon Jun 28 21:02:16 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "CommonEntryPage.h"

#define Inherited CommonEntryPageData

#include <qvalidator.h>
#include <qkeycode.h>

#include <kapp.h>
#include "QueryManager.h"
#include "resource.h"
#include "../docprop-dialogs/DocPropDlg.h"


class BlockAllValidator : public QValidator
{
 public:

  BlockAllValidator ()
    : QValidator (0, 0) {}

#ifdef EA_QT2x
  State validate (QString&, int& ) const {
    return Invalid; }
#else
  State validate (QString&, int& ) {
    return Invalid; }
#endif

};


CommonEntryPage::CommonEntryPage
(
        QDialog    *_dlgbook,
        kvoctrainDoc *_doc,
        bool        multi_sel,
        QString     expr,
        int         less,
        QComboBox  *lessbox,
        QString     lang,
        QString     rem,
        QString     act_type,
        QString     pron,
        QString     exa,
        const char *label,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name ),
	pronunce(pron),
        example(exa),
	remark(rem),
	expression(expr),
        lesson(less),
        type (act_type),
        dlgbook(_dlgbook),
        doc(_doc)
{
    setLessonBox (lessbox, less);
    lesson_label->setBuddy(lesson_box);

    setTypeBox(act_type);
    type_label->setBuddy(type_box);
    subtype_label->setBuddy(subtype_box);

    int start = -1;
    int i = 0;
    while (start < 0 && i < (int) all_types.size()) {
      if (all_types [i].shortStr() == QueryManager::getMainType(act_type))
        start = i;
      i++;
    }
    int offset = -1;
    while (offset < 0 && i < (int) all_types.size()) {
      if (all_types [i].shortStr() == act_type)
        offset = i - start;
      i++;
    }
    if (offset >= 0) {
      slotSubTypeSelected(offset-1);
      subtype_box->setCurrentItem(offset);
    }

    remark_line->setText(remark);
    remark_label->setBuddy(remark_line);

    pronunce_line->setText(pronunce);
    pronunce_label->setBuddy(pronunce_line);

    examp_line->setText(example);
    examp_label->setBuddy(examp_line);

    expr_label->setText( label );
    expr_label->setBuddy(expr_line);

    expr_line->setText(expression);

    lesson_box->setValidator (new BlockAllValidator() );
    type_box->setValidator (new BlockAllValidator() );
    subtype_box->setValidator (new BlockAllValidator() );
    if (multi_sel) {
      expr_line->setEnabled (false);
      remark_line->setEnabled (false);
      pronunce_line->setEnabled (false);
      examp_line->setEnabled (false);
      expr_line->setText ("");
      remark_line->setText ("");
      pronunce_line->setText ("");
      examp_line->setText ("");
      lesson_box->clearEdit();
      type_box->clearEdit();
      subtype_box->clearEdit();
    }
    else {
      expr_line->selectAll();
      expr_line->setFocus();
    }

    // list-win and pron-win have same size
    // buttons also have same size
    QPixmap list_pm = QPixmap(EA_KDEDATADIR("", "kvoctrain/list-win.xpm"));
    int x_add = b_LessDlg->width() - list_pm.width() +4;
    int y_add = b_LessDlg->height() - list_pm.height() +4;

    lesson_dirty = false;
    b_LessDlg->setGeometry( b_LessDlg->x()-2, b_LessDlg->y()-2,
                   list_pm.width()+x_add, list_pm.height()+y_add );
    b_LessDlg->setPixmap(list_pm);

    type_dirty = false;
    b_TypeDlg->setGeometry( b_TypeDlg->x()-2, b_TypeDlg->y()-2,
                   list_pm.width()+x_add, list_pm.height()+y_add );
    b_TypeDlg->setPixmap(list_pm);

    QPixmap pron_pm = QPixmap(EA_KDEDATADIR("", "kvoctrain/pron-win.xpm"));
    b_pronDlg->setGeometry( b_pronDlg->x()-2, b_pronDlg->y()-2,
                   pron_pm.width()+x_add, pron_pm.height()+y_add );
    b_pronDlg->setPixmap(pron_pm);
    b_pronDlg->setEnabled (false);
}


void CommonEntryPage::initFocus() const
{
  expr_line->setFocus();
}


void CommonEntryPage::setTypeBox(const QString &act_type)
{
    all_types = QueryManager::getRelation(false);
    all_maintypes = QueryManager::getRelation(true);

    QString s = QueryManager::getMainType(act_type)+QM_TYPE_DIV;
    int curr_type = 0;
    type_box->clear();
    type_box->insertItem (i18n("<none>"));
    for (int i = 0; i < (int) all_maintypes.size(); i++) {
      type_box->insertItem (all_maintypes[i].longStr());
      if (s == all_maintypes[i].shortStr()+QM_TYPE_DIV)
        curr_type = i+1;
    }
    type_box->setCurrentItem(curr_type);
    slotTypeSelected(curr_type);
}


void CommonEntryPage::setLessonBox(QComboBox *lessbox, int lesson)
{
    lesson_box->clear();
    for (int i = 0; i < lessbox->count(); i++)
      lesson_box->insertItem (lessbox->text(i));
    if (lesson >= lesson_box->count() )
      lesson = 0;
    lesson_box->setCurrentItem(lesson);
}


CommonEntryPage::~CommonEntryPage()
{
}


void CommonEntryPage::slotLessonSelected (int l)
{
  lesson = l;
  lesson_dirty = true;
}


void CommonEntryPage::slotExprSelected (EA_QTSTR s)
{
  expression = s;
}


void CommonEntryPage::slotRemarkSelected (EA_QTSTR s)
{
  remark = s;
}


void CommonEntryPage::slotPronunceSelected (EA_QTSTR s)
{
  pronunce = s;
}


void CommonEntryPage::slotExampSelected (EA_QTSTR s)
{
  example = s;
}


void CommonEntryPage::slotSubTypeSelected(int i)
{
   if (i < (int) current_subtypes.size()) {
     type = current_subtypes[i];
     emit typeSelected(type);
     type_dirty = true;
   }
}


void CommonEntryPage::slotTypeSelected(int idx)
{
   subtype_box->clear();
   current_subtypes.clear();
   bool first = true;

   if (idx == 0)  // 0 == none !
     type = "";
   else {
     type = all_maintypes[idx-1].shortStr();
     emit typeSelected(type);
     int len = all_maintypes[idx-1].longStr().length(); // cut off main ident
     QString main_patt = all_maintypes[idx-1].shortStr()+QM_TYPE_DIV;
     int sub_idx;
     if ( idx-1 < (int) all_types.size() ){
       for (sub_idx = 0; sub_idx < (int) all_types.size(); sub_idx++) {
         if (all_types[sub_idx].shortStr().left(main_patt.length()) == main_patt) {
           if (first) {
             subtype_box->insertItem (i18n("<none>"));
             current_subtypes.push_back(all_maintypes[idx-1].shortStr());
             first = false;
           }
           QString s = all_types[sub_idx].longStr();
           s.remove(0, len);
           subtype_box->insertItem (s.stripWhiteSpace());
           current_subtypes.push_back(all_types[sub_idx].shortStr());
         }
       }
     }
   }
   type_dirty = true;

   subtype_box->setEnabled(!first);
   subtype_label->setEnabled(!first);
}


void CommonEntryPage::invokePronDlg()
{
   cout << "Pron-dlg\n";
}


void CommonEntryPage::invokeLessDlg()
{
  vector<int> lessonIndex;
  vector<QString> new_lessonStr;

  int act_less = lesson_box->currentItem();
  int old_lessons = (int) lesson_box->count();
  QTabDialog lessOpt(0, "", true);
  lessOpt.setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));

  lessOpt.setCaption (QString(KVOCTRAIN_TITLE) + ": " + "name");
  LessOptPage *lessOptPage = new LessOptPage (lesson_box, doc, this, "name");
  lessOpt.addTab( lessOptPage, _DocDlg_LESSONS);

  lessOpt.setCancelButton();
  connect( &lessOpt, SIGNAL(applyButtonPressed()),  &lessOpt, SLOT(accept()) );
  connect( &lessOpt, SIGNAL(cancelButtonPressed()), &lessOpt, SLOT(reject()) );

  if (lessOpt.exec() == QDialog::Accepted) {
    lessOptPage->getLesson(lesson_box, lessonIndex);
    LessOptPage::cleanUnused(doc, lesson_box, lessonIndex, old_lessons);
    for (int i = 1; i < lesson_box->count(); i++)
      new_lessonStr.push_back(lesson_box->text(i));
    doc->setLessonDescr (new_lessonStr);
    doc->setModified();
  }
}


void CommonEntryPage::invokeTypeDlg()
{
  vector<int> typeIndex;
  vector<QString> new_typeStr;

  int old_types = (int) doc->getTypeDescr().size();
  QTabDialog typeOpt(0, "", true);
  typeOpt.setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
  typeOpt.setCaption (QString(KVOCTRAIN_TITLE) + ": " + "name");
  TypeOptPage *typeOptPage
    = new TypeOptPage (doc->getTypeDescr(), doc, this, "name");
  typeOpt.addTab( typeOptPage, _DocDlg_TYPES);

  typeOpt.setCancelButton();
  connect( &typeOpt, SIGNAL(applyButtonPressed()),  &typeOpt, SLOT(accept()) );
  connect( &typeOpt, SIGNAL(cancelButtonPressed()), &typeOpt, SLOT(reject()) );

  if (typeOpt.exec() == QDialog::Accepted) {
    typeOptPage->getTypeNames(new_typeStr, typeIndex);
    TypeOptPage::cleanUnused(doc, typeIndex, old_types);
    QueryManager::setTypeNames (new_typeStr);
    setTypeBox(type);
    doc->setTypeDescr (new_typeStr);
    doc->setModified();
  }
}


void CommonEntryPage::keyPressEvent( QKeyEvent *e )
{
   if (e->state() & AltButton & ControlButton & ShiftButton == 0) {
     if (  e->key() == Key_Escape )
       emit reject();
     else if (  e->key() == Key_Enter
              ||e->key() == Key_Return)
       emit accept();
     else
       e->ignore();
   }
   else
     e->ignore();
}
