/***************************************************************************
                          dokvok.cpp  -  description
                             -------------------
    begin                : Son Dez 19 13:14:00 CET 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>

// application specific includes
#include "dokvok.h"
#include "View//dokvokview.h"
#include "dokvokdoc.h"
#include "resource.h"
#include "Dialoge/dokvokdialog.h"

#include <iostream.h>

DokVokApp::DokVokApp()
{
  config = kapp->getConfig();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initKeyAccel();
  initDocument();
  initView(); 
	
  readOptions();
  
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
//  disableCommand(ID_FILE_SAVE);
//  disableCommand(ID_FILE_SAVE_AS);
//  disableCommand(ID_FILE_PRINT);  //TODO: unless printing is not implemented
 	
//  disableCommand(ID_EDIT_CUT);
//  disableCommand(ID_EDIT_COPY);
  disableCommand(ID_EDIT_PASTE);
  
  connect( new KDNDDropZone(this , DndURL), SIGNAL(dropAction(KDNDDropZone *)), SLOT(slotDropEvent(KDNDDropZone *)));
}

DokVokApp::~DokVokApp()
{

}

void DokVokApp::initKeyAccel()
{
  keyAccel = new KAccel(this);
	
  // fileMenu accelerators
  keyAccel->connectItem(KAccel::New, this, SLOT(slotFileNew()));
  keyAccel->connectItem(KAccel::Open, this, SLOT(slotFileOpen()));
  keyAccel->connectItem(KAccel::Save, this, SLOT(slotFileSave()));
  keyAccel->connectItem(KAccel::Close, this, SLOT(slotFileClose()));
  keyAccel->connectItem(KAccel::Print, this, SLOT(slotFilePrint()));
  keyAccel->connectItem(KAccel::Quit, this, SLOT(slotFileQuit()));
  // editMenu accelerators
  keyAccel->connectItem(KAccel::Cut, this, SLOT(slotEditCut()));
  keyAccel->connectItem(KAccel::Copy, this, SLOT(slotEditCopy()));
  keyAccel->connectItem(KAccel::Paste, this, SLOT(slotEditPaste()));

  keyAccel->connectItem(KAccel::Help, kapp, SLOT(appHelpActivated()));
			
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_NEW, KAccel::New);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_OPEN, KAccel::Open);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_SAVE, KAccel::Save);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_CLOSE, KAccel::Close);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_PRINT, KAccel::Print);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_QUIT, KAccel::Quit);

  keyAccel->changeMenuAccel(editMenu, ID_EDIT_CUT, KAccel::Cut);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_COPY, KAccel::Copy);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_PASTE, KAccel::Paste);

  keyAccel->readSettings();	
}

void DokVokApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR
  recentFilesMenu = new QPopupMenu();
  connect(recentFilesMenu, SIGNAL(activated(int)), SLOT(slotFileOpenRecent(int)));
  
  TypMenu = new QPopupMenu();
  connect( TypMenu, SIGNAL(activated(int)), SLOT(slotEditTypSelected(int)));

//schliessen verwerfen  
  
  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu
  fileMenu = new QPopupMenu();
  fileMenu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW);
  fileMenu->insertItem(Icon("filenewfrom.xpm"), i18n("New &from..."), ID_FILE_NEW_FROM);
  fileMenu->insertItem(Icon("filenewfromthis.xpm"), i18n("New from &this"), ID_FILE_NEW_FROM_THIS);
  fileMenu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN);
  fileMenu->insertItem(i18n("Open &recent"), recentFilesMenu, ID_FILE_OPEN_RECENT);
  fileMenu->insertSeparator();
  fileMenu->insertItem(Icon("filerevert.xpm"), i18n("Re&vert"), ID_FILE_REVERT);
//  fileMenu->insertItem(i18n("Cl&ear"), ID_FILE_CLOSE);
  fileMenu->insertItem(Icon("filedel.xpm"), i18n("&Delete"), ID_FILE_DELETE);
  fileMenu->insertSeparator();
  fileMenu->insertItem(Icon("filesave.xpm") ,i18n("&Save"), ID_FILE_SAVE);
  fileMenu->insertSeparator();
//  fileMenu->insertItem(Icon("filenotsave.xpm"), i18n("T&urn down"), ID_FILE_QUIT);
  fileMenu->insertItem(Icon("exit.xpm"), i18n("&Close"), ID_FILE_QUIT);

/*  fileMenu->insertItem(kapp->getMiniIcon(), i18n("New &Window"), ID_FILE_NEW_WINDOW);
  fileMenu->insertSeparator();
  fileMenu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW);
  fileMenu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN);
  fileMenu->insertItem(i18n("Open &recent"), recentFilesMenu, ID_FILE_OPEN_RECENT);

  fileMenu->insertItem(i18n("&Close"), ID_FILE_CLOSE);
  fileMenu->insertSeparator();
  fileMenu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"), ID_FILE_SAVE);
  fileMenu->insertItem(i18n("Save &As..."), ID_FILE_SAVE_AS);
*  fileMenu->insertSeparator();
  fileMenu->insertItem(Icon("fileprint.xpm"), i18n("&Print..."), ID_FILE_PRINT);
*  fileMenu->insertSeparator();
  fileMenu->insertItem(Icon("exit.xpm"), i18n("E&xit"), ID_FILE_QUIT);
*/  	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry editMenu
  editMenu = new QPopupMenu();
  editMenu->insertItem(Icon("editcut.xpm"), i18n("Cu&t"), ID_EDIT_CUT);
  editMenu->insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_EDIT_COPY);
  editMenu->insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_EDIT_PASTE);
  editMenu->insertSeparator();
  editMenu->insertItem(i18n("&Set Typ"), TypMenu, ID_EDIT_SET_TYP );
  editMenu->insertItem(i18n("&New Vokabel"), ID_EDIT_NEW_VOKABEL );
  editMenu->insertSeparator();
  editMenu->setCheckable(true);
  editMenu->insertItem(i18n("&Editmode"), ID_EDIT_EDITMODE );
  editMenu->setCheckable(false);
  editMenu->insertSeparator();
  editMenu->insertItem(i18n("&Select all"), ID_EDIT_SELECT_ALL );
  editMenu->insertItem(i18n("&Deselect all"), ID_EDIT_DESELECT_ALL );
  editMenu->insertItem(i18n("&Invert Selection"), ID_EDIT_INVERT_SELECTION );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
  viewMenu = new QPopupMenu();
  viewMenu->setCheckable(true);
  viewMenu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
  viewMenu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry listMenu
  listMenu = new QPopupMenu();
  listMenu->insertItem( Icon("configure.xpm"), i18n("&Properties"), ID_LIST_PROPERTIES );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry learningMenu
  learningMenu = new QPopupMenu();
  learningMenu->insertItem( i18n("&Start"), ID_LEARNING_START );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry settingsMenu
  settingsMenu = new QPopupMenu();
  settingsMenu->insertItem( Icon("configure.xpm"), i18n("&General"), ID_SETTINGS_GENERAL );
  settingsMenu->insertItem( Icon("help.xpm"), i18n("&Questioning"), ID_SETTINGS_QUESTIONING );
  settingsMenu->insertItem( Icon("languages.xpm"), i18n("&Languages"), ID_SETTINGS_LANGUAGES );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  QString aboutstring=kapp->appName()+" "+VERSION+"\n\nJust a snapshot,\ndevelopment is going on...\n\nPlease give feedback to the author:\nFriedrich.W.H@Kossebau.de";

  helpMenu = new QPopupMenu();
  helpMenu = kapp->getHelpMenu(true, aboutstring);

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // insert your popup menus with the according menubar entries in the order
  // they will appear later from left to right
  menuBar()->insertItem(i18n("&File"), fileMenu);
  menuBar()->insertItem(i18n("&Edit"), editMenu);
  menuBar()->insertItem(i18n("&View"), viewMenu);
  menuBar()->insertItem(i18n("&List"), listMenu);
  menuBar()->insertItem(i18n("&Learning"), learningMenu);
  menuBar()->insertItem(i18n("&Settings"), settingsMenu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), helpMenu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE MENU SLOTS WITH SIGNALS
  // for execution slots and statusbar messages

  connect(fileMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(fileMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(editMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(editMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(viewMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(viewMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(listMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(listMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(learningMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(learningMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(settingsMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(settingsMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

}

void DokVokApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New File"));
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open File"));
  toolBar()->insertButton(Icon("filesave.xpm"), ID_FILE_SAVE, true, i18n("Save File"));
/*  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print"));*/
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("editcut.xpm"), ID_EDIT_CUT, true, i18n("Cut"));
  toolBar()->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy"));
  toolBar()->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("pencil.xpm"), ID_EDIT_EDITMODE, true, i18n("Editmode"));
  toolBar()->setToggle( ID_EDIT_EDITMODE );

/*  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked()),
  				kapp, SLOT(appHelpActivated()), true,i18n("Help"));
*/
  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE WITH toolBar(n)


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
  // connect for invoking the slot actions
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
  // connect for the status help on holing icons pressed with the mouse button
  connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));

}

void DokVokApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem( i18n("Ready."), ID_STATUS_MSG );
}

void DokVokApp::initDocument()
{
  doc = new DokVokDoc(this);
  
  connect( doc, SIGNAL( newTitel() ), SLOT( setWindowCaption() ) );
  connect( doc, SIGNAL( newTypInfoList(VTypInfoList *) ), SLOT( fillTypMenu(VTypInfoList *) ) );
  connect( doc, SIGNAL( clipboardHasData( bool ) ), SLOT( setClipboard( bool ) ) );
  connect( doc, SIGNAL( editModeHasChanged( bool ) ), SLOT( setEditMode( bool ) ) );
  
  doc->newDocument();
}

void DokVokApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new DokVokView(this);
  doc->addView(view);
  setView(view);
  setWindowCaption();

}

void DokVokApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, true);
  toolBar()->setItemEnabled(id_, true);
}

void DokVokApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, false);
  toolBar()->setItemEnabled(id_, false);
}

void DokVokApp::setState(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // set menu and toolbar functions state by their ID's
  menuBar()->setItemChecked( id_, true );
  toolBar()->setButton( id_, true );
}

void DokVokApp::unsetState(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // unset menu and toolbar functions state by their ID's 
  menuBar()->setItemChecked( id_, false );
  toolBar()->setButton( id_, false );
}

void DokVokApp::addRecentFile(const QString &Filename)
{
  int Rank;
  if( (Rank=recentFiles.find( Filename )) != -1)
  // is already in the list
  {
    recentFiles.remove( Rank );
  }
  
  if( recentFiles.count() > 4)
  // limited to 5 
    recentFiles.remove(4);
    
  // insert at the begin
  recentFiles.insert(0, Filename );
  
  // refresh recentFileMenu
  fillRecentFileMenu();
}


void DokVokApp::fillRecentFileMenu()
{
  int Rank;
  recentFilesMenu->clear();
  QString Entry;
  for ( Rank=0 ; Rank < (int) recentFiles.count(); Rank++)
  {
    Entry.setNum(Rank+1);
    Entry = "&"+Entry+". "+recentFiles.at(Rank);
    recentFilesMenu->insertItem( Entry );
  }
}


void DokVokApp::fillTypMenu( VTypInfoList *List )
{
  TypMenu->clear();
  TypMenu->insertItem( i18n("no typ") );
  
  VTypInfo *TypInfo;
  for( TypInfo=List->first(); TypInfo; TypInfo=List->next() )
    TypMenu->insertItem( TypInfo->localName().data() );
}


/** */
bool DokVokApp::openDocument( QString Filename )
{
//  cerr << "open: " << Filename << "\n";
  bool Success;
  if( !(Success = doc->openDocument(Filename)) )
    KMsgBox::message( this, i18n("Sorry"), i18n("The file ")+Filename+i18n(" couldn't be opened.") );
  return Success;
}


/** */
bool DokVokApp::saveDocument( QString Filename )
{
//  cerr << "save: " << Filename << "\n";
  bool Success;
  if( Success = doc->saveDocument(Filename) )
    addRecentFile( Filename ); 
  else
    KMsgBox::message( this, i18n("Sorry"), i18n("This document couldn't be saved\nunder the filename ")+Filename+i18n(".") );
    
  return Success;
}


/** */
void DokVokApp::startWithFile( const char* Filename = 0  )
{
  slotStatusMsg(i18n("Opening file..."));

  // any file to start with?
  if( Filename )
  {
    // a file is explicitly given
    if( openDocument( Filename ) )
      addRecentFile( Filename );
  }
  else
  {
    // take the last one if allowed to do so
    Filename = recentFiles.at( 0 );    
    if( AutoLoadLastFile && Filename )
      openDocument( Filename );
  }

  slotStatusMsgReady();
}


DokVokDoc *DokVokApp::getDocument() const
{
  return doc;
}

void DokVokApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int) menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos", (int) toolBar()->barPos());
  config->writeEntry("Recent Files", recentFiles);
  config->writeEntry("Standard Directory", getStandardDirectory() );
  config->writeEntry("Autoload last File", AutoLoadLastFile );
  
  config->setGroup("Question Options");
  doc->writeQuestionSettings( config );
}


void DokVokApp::readOptions()
{
	
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewMenu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  if(!bViewToolbar)
  {
     enableToolBar(KToolBar::Hide);
  }
	
  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewMenu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  if(!bViewStatusbar)
  {
    enableStatusBar(KStatusBar::Hide);
  }

  // bar position settings
  KMenuBar::menuPosition menuBarPos;
  menuBarPos=(KMenuBar::menuPosition) config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);

  menuBar()->setMenuBarPos(menuBarPos);
  toolBar()->setBarPos(toolBarPos);
	
  // initialize the recent file list
  recentFiles.setAutoDelete(TRUE);
  config->readListEntry("Recent Files", recentFiles);
	
  fillRecentFileMenu();
  
  QSize Size=config->readSizeEntry("Geometry");
  if( !Size.isEmpty() )
  {
    resize( Size );
  }
  
  // sets the standard directory
  setStandardDirectory( config->readEntry( "Standard Directory", QDir::homeDirPath() ) );
  
  // start with the last used file?
  AutoLoadLastFile = config->readBoolEntry( "Autoload last file", false );
  
  config->setGroup("Question Options");

  doc->readQuestionSettings( config );
}

void DokVokApp::saveProperties( KConfig *Config )
{
  if( doc->isNew() && !doc->isModified() )
  {
    // saving to tempfile not necessary
  }
  else
  {
    Config->writeEntry( "Filename", doc->fileName() );
    Config->writeEntry( "Dirname", doc->absoluteDirName() );
    Config->writeEntry( "Modified", doc->isModified());
		
    QString TempFilename = kapp->tempSaveName( doc->absoluteFileName() );
    doc->saveDocument( TempFilename );
  }
}


void DokVokApp::readProperties( KConfig* Config )
{
  QString Filename = Config->readEntry( "Filename", "" );
  QString Dirname = Config->readEntry( "Dirname", "" );
  bool WasModified = Config->readBoolEntry( "Modified", false );
  
  QString Fullname = Dirname + '/' + Filename;
  
  if( WasModified || Filename.isEmpty() )
  {
  
    bool CanRecover;
    QString TempFilename = kapp->checkRecoverFile( Fullname, CanRecover );
  	
    if( CanRecover ) 
    {
      // load file content from temp file
      openDocument( TempFilename );
      
      // setup old properties
      doc->setAbsoluteDirName( Dirname );
      doc->setFileName( Filename );
      doc->setModified();

      // no more need for the temp file, thank you, was great work
      QFile::remove( TempFilename );
    }
  }
  else
  {
    if( !Filename.isEmpty() )
      openDocument( Fullname );
  }
}		


bool DokVokApp::saveAs()
{
  QString newName = getStandardDirectory(); // this is where to start
  int want_save = 2;   // Back... in the beginning is the beginning
  
  while( want_save == 2 )  
  {
    newName = KFileDialog::getSaveFileName( newName, i18n( "*.vok|DokVok files (*.vok)\n*|All files (*)" ), this, i18n("Save as..."));
    
    if( newName.isEmpty() )
      // no name given or cancelled
      return false;
    else
    {
      // check if filename is in use
      QFileInfo saveAsInfo( newName );
      if( !saveAsInfo.exists() )
        want_save = 1;      // Ok, is new...
      else 
      {                     // Hm, already in use, ask user... returned 2 means: go back
        want_save = KMsgBox::yesNoCancel(this, i18n("Warning"),
                                         i18n("The selected filename\n")
                                         +saveAsInfo.fileName()+
                                         i18n("\n is in use.\nSave anyway?"), 
                                         KMsgBox::DB_SECOND|KMsgBox::QUESTION, 0, i18n("Back"));
      }
      
      if( want_save == 1 )  // Filename is ok...
      {
        doc->setFileName( saveAsInfo.fileName() );
        doc->setAbsoluteDirName( saveAsInfo.dirPath() );
        
        return saveDocument( newName );
      }
    }
  }
  return false;
}


bool DokVokApp::saveModified()
{
  bool Proceed = true;

  if( doc->isModified() )
  {
    int want_save = KMsgBox::yesNoCancel(this, i18n("Warning"),
                                         i18n("The current document has been modified.\n"
                                              "Do you want to save it?"));
    switch( want_save )
    {
      // Yes
      case 1:  slotFileSave();
               break;
      // No
      case 2:  doc->setModified( false );
               break;	

      // Cancel
      case 3:  Proceed = false;
               break;

      default: Proceed = false;
               break;
    }
  }

  return Proceed;
}


bool DokVokApp::queryClose()
{
  return saveModified();
}

bool DokVokApp::queryExit()
{
  saveOptions();
  return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void DokVokApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new application window..."));
	
  DokVokApp *new_window= new DokVokApp();
  new_window->show();

  slotStatusMsgReady();
}

void DokVokApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new document..."));
	
  if( !saveModified() )
  {
     // here saving wasn't successful
  }
	else
	{	
	  doc->newDocument();		
	}

  slotStatusMsgReady();
}


void DokVokApp::slotFileNewFrom()
{
  slotStatusMsg(i18n("Creating new list from..."));

  if(!saveModified())
  {
     // here saving wasn't successful
  }
  else
  {	
    QString fileToOpen=KFileDialog::getOpenFileName(getStandardDirectory(),
                                                    i18n( "*.vok|DokVok files (*.vok)\n*|All files (*)" ), this, i18n("Open File..."));
    if(!fileToOpen.isEmpty())
    {
      if( openDocument(fileToOpen) )
      {
        doc->setAsCopy();
      }
    }
  }

  slotStatusMsgReady();
}


void DokVokApp::slotFileNewFromThis()
{
  slotStatusMsg(i18n("Creating new list from this..."));

  if( !saveModified() )
  {
     // here saving wasn't successful
  }
  else
  {	
    doc->setAsCopy();
  }

  slotStatusMsgReady();
}


void DokVokApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));
	
  if( !saveModified() )
  {
     // here saving wasn't successful
  }
  else
  {	
    QString fileToOpen=KFileDialog::getOpenFileName(getStandardDirectory(),
                                                    i18n( "*.vok|DokVok files (*.vok)\n*|All files (*)" ), this, i18n("Open File..."));
    if(!fileToOpen.isEmpty())
    {
      if( openDocument(fileToOpen) )
        addRecentFile(fileToOpen);
    }
  }

  slotStatusMsgReady();
}


void DokVokApp::slotFileOpenRecent( int Index )
{
  slotStatusMsg(i18n("Opening file..."));
	
  if( !saveModified() )
  {
     // here saving wasn't successful
  }
  else
  {
    if( openDocument(recentFiles.at( Index )) )
    {
      addRecentFile( recentFiles.at(Index) ); // moves it at first position
    }
    else 
    {
    	// that file isn't usable any more it seems so forget it
      recentFiles.remove( Index );
      fillRecentFileMenu();
    }
  }

  slotStatusMsgReady();
}

void DokVokApp::slotFileSave()
{
  slotStatusMsg( i18n("Saving file...") );
  
  if( doc->isNew() )
  {
    saveAs();
  }
  else
  {
    saveDocument( doc->absoluteFileName() );
  }
  slotStatusMsgReady();
}


void DokVokApp::slotFileSaveAs()
{
  slotStatusMsg( i18n("Saving file with a new filename...") );
  
  saveAs();

  slotStatusMsgReady();
}


void DokVokApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));
	
  close();

  slotStatusMsgReady();
}

void DokVokApp::slotFileRevert()
{
  slotStatusMsg(i18n("Opening file..."));
	
  if( KMsgBox::yesNo(this, i18n("Warning"), i18n("Should really all changes get lost?") ) == 1 )
  {
    openDocument( doc->absoluteFileName() );
  }

  slotStatusMsgReady();
}


void DokVokApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this))
  {
    view->print(&printer);
  }

  slotStatusMsgReady();
}

void DokVokApp::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));
  saveOptions();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KTMainWindow* w;
  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->first())
    {
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
	break;
    }
  }	
  slotStatusMsgReady();
}

void DokVokApp::slotEditDelete()
{
  slotStatusMsg(i18n("Deleting selection..."));

  doc->deleteSelection();

  slotStatusMsgReady();
}

void DokVokApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));

  doc->cutSelection();

  slotStatusMsgReady();
}

void DokVokApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to clipboard..."));
  
  doc->copySelection();

  slotStatusMsgReady();
}

void DokVokApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting clipboard contents..."));

  doc->pasteFromClipboard();

  slotStatusMsgReady();
}

void DokVokApp::slotEditSelectAll()
{
  slotStatusMsg(i18n("Selecting all..."));

  view->selectAll();

  slotStatusMsgReady();
}

void DokVokApp::slotEditDeselectAll()
{
  slotStatusMsg(i18n("Deselecting all..."));

  view->deselectAll();

  slotStatusMsgReady();
}

void DokVokApp::slotEditInvertSelection()
{
  slotStatusMsg(i18n("Inverting Selection..."));

  view->invertSelection();

  slotStatusMsgReady();
}

void DokVokApp::slotEditTypSelected( int TypIndex )
{
  doc->setTyp( TypIndex );
}

void DokVokApp::slotEditNewVokabel()
{
  slotStatusMsg(i18n("Inserting new vokabel..."));

  if( !view->isEditMode() ) 
  {
    setState( ID_EDIT_EDITMODE );
  }
  doc->appendVokabel();

  slotStatusMsgReady();
}

void DokVokApp::slotEditEditMode()
{
  slotStatusMsg(i18n("Toggle the edit mode..."));
  ///////////////////////////////////////////////////////////////////
  // turn Editmode on or off
  if( editMenu->isItemChecked(ID_EDIT_EDITMODE) )
    doc->slotSetEditMode( false );
  else
    doc->slotSetEditMode( true );

  slotStatusMsgReady();
}

void DokVokApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggle the toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if( viewMenu->isItemChecked(ID_VIEW_TOOLBAR))
  {
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
    enableToolBar(KToolBar::Hide);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
    enableToolBar(KToolBar::Show);
  }		

  slotStatusMsgReady();
}

void DokVokApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if( viewMenu->isItemChecked(ID_VIEW_STATUSBAR))
  {
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
    enableStatusBar(KStatusBar::Hide);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
    enableStatusBar(KStatusBar::Show);
  }

  slotStatusMsgReady();
}


void DokVokApp::slotListProperties()
{
  slotStatusMsg(i18n("Editing list properties..."));

  doc->editProperties();  

  slotStatusMsgReady();
}


void DokVokApp::slotLearningStart()
{
  slotStatusMsg(i18n("Starting learning..."));

  doc->learning();  

  slotStatusMsgReady();
}


void DokVokApp::slotSettingsGeneral()
{
  slotStatusMsg(i18n("Editing DokVok general settings..."));

  editGeneralSettings();  

  slotStatusMsgReady();
}


void DokVokApp::slotSettingsQuestioning()
{
  slotStatusMsg(i18n("Editing DokVok questioning settings..."));

  doc->editQuestionSettings();  

  slotStatusMsgReady();
}


void DokVokApp::slotSettingsLanguages()
{
  slotStatusMsg(i18n("Editing DokVok languages..."));

  doc->editLanguages();  

  slotStatusMsgReady();
}


void DokVokApp::slotStatusMsgReady()
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem( i18n("Ready."), ID_STATUS_MSG );
}


void DokVokApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}


void DokVokApp::slotStatusHelpMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void DokVokApp::commandCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
         slotFileNewWindow();
    	 break;

    case ID_FILE_NEW:
    	 slotFileNew();
         break;

    case ID_FILE_NEW_FROM:
    	 slotFileNewFrom();
         break;

    case ID_FILE_NEW_FROM_THIS:
    	 slotFileNewFromThis();
         break;

    case ID_FILE_OPEN:
         slotFileOpen();
         break;

    case ID_FILE_REVERT:
         slotFileRevert();
         break;

    case ID_FILE_SAVE:
         slotFileSave();
         break;

    case ID_FILE_SAVE_AS:
         slotFileSaveAs();
         break;

    case ID_FILE_CLOSE:
         slotFileClose();
         break;

    case ID_FILE_PRINT:
         slotFilePrint();
         break;

    case ID_FILE_QUIT:
         slotFileQuit();
         break;

    case ID_EDIT_CUT:
         slotEditCut();
         break;

    case ID_EDIT_COPY:
         slotEditCopy();
         break;

    case ID_EDIT_PASTE:
         slotEditPaste();
         break;
  
    case ID_EDIT_NEW_VOKABEL:
	       slotEditNewVokabel();
         break;

    case ID_EDIT_EDITMODE:
	       slotEditEditMode();
         break;

    case ID_EDIT_SELECT_ALL:
	       slotEditSelectAll();
         break;

    case ID_EDIT_DESELECT_ALL:
	       slotEditDeselectAll();
         break;

    case ID_EDIT_INVERT_SELECTION:
	       slotEditInvertSelection();
         break;

    case ID_VIEW_TOOLBAR:
         slotViewToolBar();
         break;

    case ID_VIEW_STATUSBAR:
         slotViewStatusBar();
         break;
    
    case ID_LIST_PROPERTIES:
         slotListProperties();
         break;

    case ID_LEARNING_START:
         slotLearningStart();
         break;

    case ID_SETTINGS_GENERAL:
         slotSettingsGeneral();
         break;

    case ID_SETTINGS_QUESTIONING:
         slotSettingsQuestioning();
         break;

    case ID_SETTINGS_LANGUAGES:
         slotSettingsLanguages();
         break;

    default:
         break;
  }
}

void DokVokApp::statusCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
         slotStatusHelpMsg(i18n("Opens a new application window"));
         break;

    case ID_FILE_NEW:
         slotStatusHelpMsg(i18n("Creates a new list"));
         break;

    case ID_FILE_NEW_FROM:
         slotStatusHelpMsg(i18n("Creates a new list based on an existing list"));
         break;

    case ID_FILE_NEW_FROM_THIS:
         slotStatusHelpMsg(i18n("Creates a new list based on the actual list"));
         break;

    case ID_FILE_OPEN:
         slotStatusHelpMsg(i18n("Opens an existing list"));
         break;

    case ID_FILE_OPEN_RECENT:
         slotStatusHelpMsg(i18n("Opens a recently used file"));
         break;

    case ID_FILE_SAVE:
         slotStatusHelpMsg(i18n("Saves the actual list"));
         break;

    case ID_FILE_SAVE_AS:
         slotStatusHelpMsg(i18n("Saves the actual list as..."));
         break;

    case ID_FILE_CLOSE:
         slotStatusHelpMsg(i18n("Closes the actual list"));
         break;

    case ID_FILE_PRINT:
         slotStatusHelpMsg(i18n("Prints out the actual list"));
         break;

    case ID_FILE_QUIT:
         slotStatusHelpMsg(i18n("Quits the application"));
         break;

    case ID_EDIT_CUT:
         slotStatusHelpMsg(i18n("Cuts the selected section and puts it to the clipboard"));
         break;

    case ID_EDIT_COPY:
         slotStatusHelpMsg(i18n("Copies the selected section to the clipboard"));
         break;

    case ID_EDIT_PASTE:
         slotStatusHelpMsg(i18n("Pastes the clipboard contents to actual position"));
         break;

    case ID_EDIT_NEW_VOKABEL:
         slotStatusHelpMsg(i18n("Appends a new vokabel to the list"));
         break;

    case ID_EDIT_SET_TYP:
         slotStatusHelpMsg(i18n("Sets the typ of the vocabel(s)"));
         break;

    case ID_EDIT_EDITMODE:
         slotStatusHelpMsg(i18n("Enables/disables the edit mode"));
         break;

    case ID_VIEW_TOOLBAR:
         slotStatusHelpMsg(i18n("Enables/disables the toolbar"));
         break;

    case ID_VIEW_STATUSBAR:
         slotStatusHelpMsg(i18n("Enables/disables the statusbar"));
         break;

    case ID_LIST_PROPERTIES:
         slotStatusHelpMsg(i18n("Opens a dialog for editing of the list properties"));
         break;

    case ID_SETTINGS_GENERAL:
         slotStatusHelpMsg(i18n("Opens a dialog for editing of the general settings"));
         break;

    case ID_SETTINGS_QUESTIONING:
         slotStatusHelpMsg(i18n("Opens a dialog for editing of the questioning settings"));
         break;

    case ID_SETTINGS_LANGUAGES:
         slotStatusHelpMsg(i18n("Opens a dialog for editing of the languages"));
         break;

    default:
         break;
  }
}

void DokVokApp::setStandardDirectory(const QString &NewDirectory)
{
  StandardDirectory = NewDirectory;
}

const QString &DokVokApp::getStandardDirectory() const
{
  return StandardDirectory;
}

/** sets the caption of the window */
void DokVokApp::setWindowCaption()
{
//  QString caption=kapp->getCaption();	
  setCaption(/*"Dok Vok: "+*/doc->titel());
}

/** opens a dialog for editing of the list properties */
void DokVokApp::editGeneralSettings()
{
  DokVokDialog Dialog;
  
  if( Dialog.wasModified( getStandardDirectory(), AutoLoadLastFile  ) )
  {//TODO: each update only if changed
  	setStandardDirectory( Dialog.standardDirectory() );
  	AutoLoadLastFile = Dialog.autoLoadLastFile();
  };
}



/** sets the insert from clipboard to Enabled/Disabled */
void DokVokApp::setClipboard( bool Enabled )
{
  if( Enabled )
    enableCommand( ID_EDIT_PASTE );
  else
    disableCommand( ID_EDIT_PASTE );
}

/** sets the insert from editmode to Enabled/Disabled */
void DokVokApp::setEditMode( bool Enabled )
{
  if( Enabled )
    setState( ID_EDIT_EDITMODE );
  else
    unsetState( ID_EDIT_EDITMODE );
}


/** */
void DokVokApp::slotDropEvent(KDNDDropZone *Zone)
{
  QString Filename = Zone->getURLList().first();

  KURL URL = Filename.data();
  Filename = URL.path();

  slotStatusMsg(i18n("Opening a new application window..."));
	
  DokVokApp *NewWindow = new DokVokApp();
  NewWindow->show();
  NewWindow->startWithFile( Filename );

  slotStatusMsgReady();
}
