/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Son Dez 19 13:14:00 CET 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <unistd.h>
#include <sys/stat.h>

#include <qdir.h>

#include <kapp.h>

#include "dokvok.h"

void testDir( QString &Name, unsigned int Mode )
{
  if ( checkAccess(Name, W_OK) ) 
  {
    QDir Dir( Name );
    if( !Dir.exists() )
  	  mkdir( Dir.path(), Mode );
  	  
    chown( Dir.path(), getuid(), getgid());
  }
}


void createLocalDirs()
{
  // create the language directory ~/.kde/share/apps/dokvok/languages
  
  QString DirName = KApplication::localkdedir().copy();
  
  testDir( DirName, 0755 ); 
  DirName += "/share"; 
  testDir( DirName, 0755 );
  DirName += "/apps";   
  testDir( DirName, 0700 );
  DirName += "/dokvok";   
  testDir( DirName, 0700 );
  DirName += "/languages";       
  testDir( DirName, 0700 );
}


int main(int argc, char *argv[])
{
  createLocalDirs();

  KApplication app(argc, argv, "dokvok");
 
  if (app.isRestored())
  {
    RESTORE(DokVokApp);
  }
  else 
  {
    DokVokApp *DokVok = new DokVokApp();
    DokVok->show();

    // load a document to start with
    if(argc>1)
    {
      // a document is explicitly given
      DokVok->startWithFile( argv[1] );
    }
    else
    {
      // let DokVok handle what to start with
      DokVok->startWithFile();
    }
    
  }

  return app.exec();

}  
