/***************************************************************************
    khistorydlg.h  -  Command history dialog interface

    begin                : Mon Dec 20 1999
    copyright            : (C) 1999 by Yury Lebedev
    email                : yurylebedev@mail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KHISTORYDLG_H
#define KHISTORYDLG_H

// include files for Qt
#include <qstring.h>
#include <qstrlist.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qpushbutton.h>

// include files for KDE
#include <kwizard.h>

/** Dialog for show SQL command history.
  * @author Yury Lebedev
  */
class KHistoryDlg : public KDialog
{
   Q_OBJECT

  /** Top dialog layout */
  QVBoxLayout topLayout;
  /** Buttons layout */
  QHBoxLayout buttonLayout;

  /** Command history list */
  QListBox historyList;

  /** Ok button */
  QPushButton okButton;
  /** Cancel button */
  QPushButton cancelButton;

public:
  /** Constructs dialog and internal widgets. */
  KHistoryDlg(QStrList* history, QWidget *parent = 0, const char *name = 0);
  /** Destructor */
  ~KHistoryDlg();

  /** Returns current selected history item index. */
  int selected() { return historyList.currentItem(); };

protected slots:
  /** slot for history list item double click signal. */
  void slotHistoryDoubleClicked(int index);
};

#endif
