/***************************************************************************
    khistorydlg.cpp  -  Command history dialog implementation

    begin                : Mon Dec 20 1999
    copyright            : (C) 1999 by Yury Lebedev
    email                : yurylebedev@mail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for KDE
#include <kapp.h>

#include "khistorydlg.h"

KHistoryDlg::KHistoryDlg(QStrList* history, QWidget *parent, const char *name ) :
  KDialog(parent, name, true),
  topLayout(this, 12, 12, "topLayout"),
  buttonLayout(6, "buttonLayout"),
  historyList(this, "historyList"),
  okButton(this, "okButton"),
  cancelButton(this, "cancelButton")
{
  // set dialog caption
  setCaption(i18n("Command history"));

  // calculate dialog and widgets size
  QFontMetrics metrics = fontMetrics();
  int h = metrics.height() + 8;
  int w = metrics.width(i18n("Cancel")) + 32;

  // init history list
  historyList.insertStrList(history);
  historyList.setMultiSelection(false);
  historyList.setFixedVisibleLines(12);
  historyList.setFixedWidth(w * 3);
  historyList.setCurrentItem(history->at());
  historyList.centerCurrentItem();

  // add components
  topLayout.addWidget(&historyList);

  // init buttons
  okButton.setText(i18n("Get"));
  okButton.setMinimumSize(w + 6, h + 6);
  okButton.setDefault(TRUE);

  cancelButton.setText(i18n("Cancel"));
  cancelButton.setMinimumSize(w + 6, h + 6);

  // add button layout to top layout
  topLayout.addLayout(&buttonLayout);
  // add components
  buttonLayout.addWidget(&okButton);
  buttonLayout.addWidget(&cancelButton);

  // organize tab order
  setTabOrder(&historyList, &okButton);
  setTabOrder(&okButton, &cancelButton);
  setTabOrder(&cancelButton, &historyList);

  // focus item
  historyList.setFocus();

  // center dialog inside parent
  if( parent )
    move(parent->x() + (parent->width() - width()) / 2,
      parent->y() + (parent->height() - height()) / 2);

  // setup slots
  connect(&cancelButton, SIGNAL(clicked()), SLOT(reject()));
  connect(&okButton, SIGNAL(clicked()), SLOT(accept()));
  connect(&historyList, SIGNAL(selected(int)), SLOT(slotHistoryDoubleClicked(int)));
}

KHistoryDlg::~KHistoryDlg()
{
}

void KHistoryDlg::slotHistoryDoubleClicked(int index)
{
  accept();
}
