/***************************************************************************
                                 KSqlReplace.cpp
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kpixmap.h>
#include <qlayout.h>
#include "ksqlreplace.h"
#include "korapic.xpm"

#include <qlabel.h>

KSqlReplace::KSqlReplace(QWidget* parent, const char* name) :
		KDialog( parent, name, TRUE, 53248 )
{
	QPixmap picture((const char**) kora_xpm);
	setIcon(picture);

	QLabel* replaceWLabel;
	replaceWLabel = new QLabel( this, "replaceWLabel" );
	replaceWLabel->setGeometry( 20, 30, 360, 30 );
	replaceWLabel->setMinimumSize( 0, 0 );
	replaceWLabel->setMaximumSize( 32767, 32767 );
	{
		QFont font( "helvetica", 14, 87, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		replaceWLabel->setFont( font );
	}
	replaceWLabel->setFocusPolicy( QWidget::NoFocus );
	replaceWLabel->setBackgroundMode( QWidget::PaletteBackground );
	replaceWLabel->setFontPropagation( QWidget::NoChildren );
	replaceWLabel->setPalettePropagation( QWidget::NoChildren );
	replaceWLabel->setFrameStyle( 0 );
	replaceWLabel->setLineWidth( 1 );
	replaceWLabel->setMidLineWidth( 0 );
	replaceWLabel->QFrame::setMargin( 0 );
	replaceWLabel->setText( i18n("Choose a replacement for") );
	replaceWLabel->setAlignment( 292 );
	replaceWLabel->setMargin( -1 );

	toReplaceLabel = new QLabel( this, "toReplaceWLabel" );
	toReplaceLabel->setGeometry( 20, 70, 360, 30 );
	toReplaceLabel->setMinimumSize( 0, 0 );
	toReplaceLabel->setMaximumSize( 32767, 32767 );
	{
		QFont font( "helvetica", 14, 75, 1 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		toReplaceLabel->setFont( font );
	}
	toReplaceLabel->setFocusPolicy( QWidget::NoFocus );
	toReplaceLabel->setBackgroundMode( QWidget::PaletteBackground );
	toReplaceLabel->setFontPropagation( QWidget::NoChildren );
	toReplaceLabel->setPalettePropagation( QWidget::NoChildren );
	toReplaceLabel->setFrameStyle( 0 );
	toReplaceLabel->setLineWidth( 1 );
	toReplaceLabel->setMidLineWidth( 0 );
	toReplaceLabel->QFrame::setMargin( 0 );
	toReplaceLabel->setText( "<Placeholder>" );
	toReplaceLabel->setAlignment(AlignLeft | AlignVCenter);
	toReplaceLabel->setMargin( -1 );

	replacementText = new QLineEdit( this, "replacementWText" );
	replacementText->setGeometry( 20, 110, 360, 30 );
	replacementText->setMinimumSize( 0, 0 );
	replacementText->setMaximumSize( 32767, 32767 );
	replacementText->setFocusPolicy( QWidget::StrongFocus );
	replacementText->setBackgroundMode( QWidget::PaletteBase );
	replacementText->setFontPropagation( QWidget::NoChildren );
	replacementText->setPalettePropagation( QWidget::NoChildren );
	replacementText->setText( "" );
	replacementText->setMaxLength( 32767 );
	replacementText->setFrame( QLineEdit::Normal );
	replacementText->setFrame( TRUE );

	replaceButton = new QPushButton( this, "replaceWButton" );
	replaceButton->setGeometry( 150, 170, 100, 30 );
	replaceButton->setMinimumSize( 0, 0 );
	replaceButton->setMaximumSize( 32767, 32767 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		replaceButton->setFont( font );
	}
	connect( replaceButton, SIGNAL(clicked()), SLOT(replaceButtonClickedCB()) );
	replaceButton->setFocusPolicy( QWidget::TabFocus );
	replaceButton->setBackgroundMode( QWidget::PaletteBackground );
	replaceButton->setFontPropagation( QWidget::NoChildren );
	replaceButton->setPalettePropagation( QWidget::NoChildren );
	replaceButton->setText( i18n("Replace") );
	replaceButton->setAutoRepeat( FALSE );
	replaceButton->setAutoResize( FALSE );
	replaceButton->setToggleButton( FALSE );
	replaceButton->setDefault( TRUE );
	replaceButton->setAutoDefault( FALSE );
	replaceButton->setIsMenuButton( FALSE );

	resize( 400,210 );
	setMinimumSize( 400, 210 );
	setMaximumSize( 400, 210 );

	setCaption( i18n("Replace Placeholder") );

	replacementText->setFocus();
}


KSqlReplace::~KSqlReplace()
{
}
void KSqlReplace::replaceButtonClickedCB()
{
	this->close();
}
