#include <kwm.h>
#include <kapp.h>
#include <qstrlist.h>
#include <qlayout.h>

#include "ThreadView.h"
#include "mysqlw.h"
#include "globals.h"

#ifndef rcsid
static const char rcsid[]="$Id: ThreadView.cpp,v 2.3 1999/07/31 00:51:56 ral Exp $";
const char*threadview_rcs(){return rcsid;}
#endif

#define Inherited CListViewData

CThreadView::CThreadView(QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    setCaption( i18n("KMySQL - ThreadView") );
    KWM::setIcon(winId(),kapp->getIcon());
    KWM::setMiniIcon(winId(),kapp->getMiniIcon());
    
    ResetTimer = new QTimer(this);
    CHECK_PTR(ResetTimer);
    connect(ResetTimer,SIGNAL(timeout()),this,SLOT(RefreshList()));
    KillButton = new QPushButton(this,"KillButton");
    CHECK_PTR(KillButton);
    KillButton->setGeometry(0,0,100,30);
    KillButton->setMinimumSize(100,30);
    KillButton->setMaximumSize(100,30);
    KillButton->setText(i18n("Kill selected"));
    connect(KillButton,SIGNAL(clicked()),this,SLOT(KillThread()));
    dlgedit_layout_1_2->addWidget(KillButton);
    resize( 450,100 );
}


CThreadView::~CThreadView()
{
}

void CThreadView::RefreshList()
{
    if (ResetTimer)
	ResetTimer->stop();
    if (!sql_server)
	return;
    stringlist*list = sql_server->get_threads();
    if (!list)
	return;
    viewList->clear();
    //    viewList->insertStrList(list);
    stringlist::iterator iter;// = list->begin();
    for (iter = list->begin();iter != list->end();++iter) {
	viewList->insertItem(iter->c_str());
    }
    delete list;
    if (ResetTimer)
	ResetTimer->start(60000,TRUE);
}

void CThreadView::hide()
{
    if (ResetTimer)
	ResetTimer->stop();
    QDialog::hide();
}

void CThreadView::show()
{
    RefreshList();
    QDialog::show();
}

void CThreadView::KillThread()
{
    int i = viewList->currentItem();
    if (i < 0)
	return;
    QString s = viewList->text(i);
    if (s.isEmpty())
	return;
    i = s.find("\t");
    if (i == -1)
	return;
    s = s.left(i);
    unsigned long pid = s.toULong();
    if (pid == 0)
	return;
    i = sql_server->kill_thread(pid);
    RefreshList();
}
