/***************************************************************************
                          kmconfig.h  -  description
                             -------------------
    begin                : Fri Jan 7 2000
    copyright            : (C) 2000 by Ian Zepp
    email                : icszepp@islc.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMCONFIG_H
#define KMCONFIG_H

#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qsize.h>
#include <qpoint.h>
#include <qtextstream.h>

#include <kapp.h>
#include <kconfig.h>


/**
  *@author Ian Zepp
  */

class KmConfig {
public: 
	KmConfig();
	~KmConfig();

	// Decide whether a root user or not
	static bool	isRootUser();

	// Saved text
	QString		getNmapExecutable();
	void		setNmapExecutable(const QString &);

	QString		getNmapVersion();
	void		setNmapVersion(const QString &);

	QString		getArguments();
	void		setArguments(const QString &);

	QString		getHostname();
	void		setHostname(const QString &);

	QString		getFtpBounceHost();
	void		setFtpBounceHost(const QString &);

	QString		getUsePingPort();
	void		setUsePingPort(const QString &);

	QString		getHumanLogPath();
	void		setHumanLogPath(const QString &);

	QString		getMachineLogPath();
	void		setMachineLogPath(const QString &);

	QStrList	getHistoryList();
	void		setHistoryList(QStrList &);

	// Sizes
	QSize		getPortViewSize();
	void		setPortViewSize(const QSize &);

	QSize		getInfoViewSize();
	void		setInfoViewSize(const QSize &);

	QSize		getNmapViewSize();
	void		setNmapViewSize(const QSize &);

	// Toggle buttons
	bool		getPortToggled();
	void		setPortToggled(bool);

	bool		getInfoToggled();
	void		setInfoToggled(bool);

	bool		getNmapToggled();
	void		setNmapToggled(bool);

	// Global coords
	QPoint		getGlobalKmap();
	void		setGlobalKmap(const QPoint &);

private:
	KConfig *	config;
};

#endif
