/* This may look like C but it's really -*- C++ -*- */

/*
    kdb - A Simple but fast database editor for the KDE
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __NEWTABLEDIALOG_H
#define __NEWTABLEDIALOG_H

// ------------------- Qt --------------------
#include <qmsgbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qwidget.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlistbox.h>

// ------------------ KDE --------------------
#include <kapp.h>  // klocale

// ---------------- My Files -----------------
#include "main.h"

class TNewTableDialog : public QDialog
{
  Q_OBJECT
  
public:
  TNewTableDialog(QWidget* parent = 0, const char* name = 0,
		  bool modal = false, WFlags f = 0);
  virtual QStrList* strings();

public slots:
  virtual void add();
  virtual void remove();
  virtual void up();
  virtual void down();
  virtual void ok();
  virtual void cancel();

private:
  QLineEdit *leItem;
  QListBox *lbItems;
  QButton *bAdd;
  QButton *bRemove;
  QButton *bUp;
  QButton *bDown;
  QButton *bOk;
  QButton *bCancel;
};

#endif
