/* This may look like C, but it's really -*- C++ -*- */

/*
    kdb - A Simple but fast database editor for the KDE
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "main.h"
#include "dbviewer.h"


/*
 * This is for people using what(1).
 */
static const char*
whatId = "@(#) " APPNAME " " VERSION "; " COPYRIGHT_STRING;


/*
 * Adds all file names in the command line to a string list.
 */
bool
getCommandLine(QStrList *list, int argc, char **argv)
{
  char *filename;

  for(int i = 1; i < argc; i++) {
    filename = argv[i];
    if(filename[0] != '-')
      list->append(filename);
  }
  return (list->count() > 0);
}


/*
 * Load given file.
 */
TCharSepDB*
loadFile(const char* fileName)
{
  KConfig* k = KApplication::getKApplication()->getConfig();
  k->setGroup("settings");

  // read separator char
  TCharSepDB *db =
    new TCharSepDB(k->readNumEntry("separator", DEFAULT_SEPARATOR));

  // check if file should contain header
  db->setContainsHeader(k->readBoolEntry("fileContainsHeader", true));

  if (db->loadFromFile(fileName)) {
    return db;
  } else {
    delete db;

    ostrstream msg;
    msg << i18n("Error reading file ") << fileName << ends;
    QMessageBox::critical(0, APPNAME, msg.str());

    return NULL;
  }
}


/*
 * Open main windows. If there are any file names on the command
 * line, open the appropiate files.
 */
int
main(int argc, char* argv[])
{
  int window_count = 0;

  KApplication app(argc, argv, APPNAME);

  if (app.isRestored()) {
    int n = 1;
    while (KTopLevelWidget::canBeRestored(n)) {
      TDBViewer *dbviewer = new TDBViewer;
      dbviewer->restore(n++);
      dbviewer->show();
    }
  } else {
    QStrList list;
    if (getCommandLine(&list, argc, argv)) {
      for(uint i = 0; i < list.count(); i++) {
	TCharSepDB *db = loadFile(list.at(i));
	if (db) {
	  QWidget* w = new
	    TDBViewer("dbviewer", db, strdup(list.at(i)));
	  w->show();
	  window_count++;
	}
      }
    }
    if (window_count == 0) {
      QWidget* mainWindow = new TDBViewer;
      mainWindow->show();
    }
  }

  return app.exec();
  MESSAGE("returned from app.exec()");
}
