/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jun 15 15:34:26 CEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/* $Header: /cvs/bibletime/bibletime/bibletime/main.cpp,v 1.1.1.1 1999/09/24 06:23:00 uhl Exp $ */
/* $Revision: 1.1.1.1 $ */

#include "bibletime.h"
#include "kstartuplogo.h"
 
int main(int argc, char* argv[]) { 
  KApplication app(argc,argv,"bibletime");

  KConfig *config=app.getConfig();
  config->setGroup("General Options");

  bool bStartLogo=config->readBoolEntry("Logo",true);

  KStartupLogo *start_logo=0;
  if(bStartLogo)
  {
	  start_logo= new KStartupLogo;
	  start_logo->show();
	}

  if (app.isRestored())
    { 
      RESTORE(BibleTimeApp);
    }
  else
  {
		  BibleTimeApp* bibletime = new BibleTimeApp;
      bibletime->show();
      bibletime->setOptions();
			
		  if(bStartLogo)
		  {
				start_logo->close();
				delete start_logo;
			};

			//first start?
			config->setGroup("General Options");
			if (!config->readBoolEntry("isConfigured", false))
				bibletime->slotSettingsOptions();	
			
			//The tip of the day
			config->setGroup("TipOfTheDay");
			if (config->readBoolEntry("show_tod", true))
				bibletime->slotHelpTipOfDay();
    }
  return app.exec();
}
