/*
    File: bar.cpp
    Version: 0.2.1
    Date: 1998/14/01
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    This is a vertical bar with frame to display values ;-)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#include "bar.h"



// constructor

bar::bar(QWidget* parent=0,float maximum=1,char* name="",
  QColor setColor=BAR_STD_SET,QColor clrColor=BAR_STD_CLR)
  : QFrame(parent,name),value(0),maximum(maximum) {  

  // Apperarence
  setFrameStyle(WinPanel|Sunken);
  
  // set brushes
  setBrush=QBrush(setColor);
  clrBrush=QBrush(clrColor);
};
  


// change value of bar

void bar::setBar(float newValue) {

  if(newValue != value) {

    // store new value
    value=newValue;

    repaint(false);

  };

};



// change maximum value

void bar::setMaximum(float newMaximum) {

  // store new value
  maximum=newMaximum;
  if(maximum<=0) maximum=1;
};



// draw content

void bar::drawContents(QPainter* p) {

  // determine dimensions of inner rectangle
  int x=contentsRect().x();
  int y=contentsRect().y();
  int w=contentsRect().width();
  int h=contentsRect().height();

  // draw the inner bar
  if(value<0) {
    // all clear, if value < 0
    p->fillRect(x,y,w,h,clrBrush);
  } else if(value>maximum) {
    // all set, if value > 1
    p->fillRect(x,y,w,h,setBrush);   
  } else {
    // partialy clr & set if value between 0 and 1
    int v=(int)((float)h*(1-value/maximum));
    p->fillRect(x,y,w,v,clrBrush);
    p->fillRect(x,y+v,w,h-v,setBrush);   
  };

};
