/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [keyinfo.c]              Extract from `terminfo'                           */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* cc -o keyinfo -lcurses keyinfo.c                                           */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#include <stdio.h>
#include <term.h>
#include <string.h>

typedef unsigned char* string;

void pcap(string qid, string cap)
// print capability 'cap'
{ string tst; int i;
if (!strcmp(cap,"")) return;
  tst = tigetstr(cap);
  if (((int)tst)<=0)
    printf("  /* capability '%s' not found. */\n",cap);
  else
  {
    printf("  { %-10s, \"",qid);
    for (i = 0; i < strlen(tst); i++)
    {
      if (tst[i] < 32 || tst[i] > 126)
        printf("\\%03o",tst[i]);
      else if (tst[i] == '\\' || tst[i] == '"')
        printf("\\%c",tst[i]);
      else
        printf("%c",tst[i]);
    }
    printf("\" },\n");
  }
}

int main(int argc, string argv[])
{ 
//setupterm((char *)0, 1, (int *)0); // using current terminal emulation
  if (argc != 2) { fprintf(stderr,"usage: %s emulation\n",argv[0]); exit(1); }
  setupterm(argv[1], 1, (int *)0);   // using 'xterm' terminal emulation
  printf("// Generated by `%s %s'. Don't change manually.\n\n",argv[0],argv[1]);
  printf("static struct keycode %s_key[] =\n",argv[1]);
  printf("{\n");
  pcap("Key_F1",     "kf1");
  pcap("Key_F2",     "kf2");
  pcap("Key_F3",     "kf3");
  pcap("Key_F4",     "kf4");
  pcap("Key_F5",     "kf5");
  pcap("Key_F6",     "kf6");
  pcap("Key_F7",     "kf7");
  pcap("Key_F8",     "kf8");
  pcap("Key_F9",     "kf9");
  pcap("Key_F10",    "kf10");
  pcap("Key_F11",    "kf11");
  pcap("Key_F12",    "kf12");
  pcap("Key_Left",   "kcub1");
  pcap("Key_Right",  "kcuf1");
  pcap("Key_Up",     "kcuu1");
  pcap("Key_Down",   "kcud1");
  pcap("Key_Home",   "khome");
  pcap("Key_End",    "kend");
  pcap("Key_Prior",  "kpp");
  pcap("Key_Next",   "knp");
  pcap("Key_Insert", "kich1");
  pcap("Key_Delete", "kdch1");
  printf("  { 0, NULL }\n");
  printf("};\n");
  return 0;
}
