/***************************************************************************
                          qsoeditdlg.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Jul 15 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "qsoeditdlg.h"
#include "calleditdlg.h"

QsoEditDlg::QsoEditDlg(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	
	int x;
	
	config = NULL;
	
	datum->setMaxLength(10);
	utc->setMaxLength(5);
	call->setMaxLength(14);
	rstAus->setMaxLength(QSO_RST_LEN - 1);
	rstEin->setMaxLength(QSO_RST_LEN - 1);
	via->setMaxLength(14);
	qsoListe = new LogListView(this);
	qsoListe->setGeometry(400,30,330,255);
	qsoListe->createQsoEditView();
		
	for(x = 0;x < banddata.anzBand();x++)
		band->insertItem(banddata.band(x));
	for(x = 0;x <= modedata.anzMode();x++)
		mode->insertItem(modedata.mode(x));
	band->setAutoCompletion(true);
	mode->setAutoCompletion(true);
	
	connect(cancelButton,SIGNAL(clicked()),this,SLOT(reject()));
	connect(qslAktiv,SIGNAL(clicked()),this,SLOT(slotQslAkt()));
}

QsoEditDlg::~QsoEditDlg(){
}

void QsoEditDlg::editQso(LogBook *alog,CQso *aqso)
{
	bool ic;
	char dummy[20];
	
	qso = aqso;
	log = alog;
	
	datum->setText(qso->datum.get(DTAUS_LONG));
	utc->setText(qso->utc.get(true));
	call->setText(qso->GetCall());
	via->setText(qso->GetViaCall());
	band->setCurrentItem(qso->GetBand());
	mode->setCurrentItem(qso->GetMode());
	rstEin->setText(qso->GetRstEin());
	rstAus->setText(qso->GetRstAus());
	ic = qso->GetQslActivity();
	qslAktiv->setChecked(ic);
	qslEin->setChecked(qso->GetQslEin());
	qslEin->setEnabled(ic);
	qslAus->setChecked(qso->GetQslAus());
	qslAus->setEnabled(ic);
	qslDirect->setChecked(qso->GetQslDirekt());
	checkButton->setEnabled(false);
	okButton->setDefault(true);
	setCaption(i18n("Edit QSO"));
	datum->setFocus();
	createQsoListe(qso->GetCall(false,dummy));
	connect(okButton,SIGNAL(clicked()),this,SLOT(slotEditOk()));
}

void QsoEditDlg::newQso(KConfig *aconfig,LogBook *alog,CQso *aqso)
{
	log = alog;
	qso = aqso;
	time_t *ptime;
	tm *gmt;	
	CDatum _datum;
	CUtc _utc;                            	
	
	config = aconfig;
	ptime = new time_t;
	time(ptime);
	gmt = gmtime(ptime);
	_datum.create(gmt->tm_mday,gmt->tm_mon,gmt->tm_year);
	_utc.create(gmt->tm_hour,gmt->tm_min);
	delete ptime;
	//datum->setText(_datum.get(DTAUS_LONG));
	//utc->setText(_utc.get(DTAUS_LONG));
	config->setGroup("Logging");
	band->setCurrentItem(config->readLongNumEntry("Band",0));
	mode->setCurrentItem(config->readLongNumEntry("Mode",0));
		checkButton->setEnabled(true);
	checkButton->setDefault(true);
	setCaption(i18n("New Qso"));
	qslAktiv->setChecked(true);
	qslDirect->setChecked(false);
	datum->setFocus();
	slotModeSelect(mode->currentItem());
	
	connect(mode,SIGNAL(activated(int)),this,SLOT(slotModeSelect(int)));
	connect(checkButton,SIGNAL(clicked()),this,SLOT(slotCheckQso()));
	connect(okButton,SIGNAL(clicked()),this,SLOT(slotNewOk()));
}

void QsoEditDlg::newQslQso(KConfig *aconfig,LogBook *alog,CQso *aqso,const char *acall,const char *adate)
{
	log = alog;
	qso = aqso;
	                         	
	config = aconfig;
	config->setGroup("Logging");
	band->setCurrentItem(config->readLongNumEntry("Band",0));
	mode->setCurrentItem(config->readLongNumEntry("Mode",0));
	checkButton->setEnabled(true);
	checkButton->setDefault(true);
	setCaption(i18n("New Qso"));
	qslAktiv->setChecked(true);
	qslDirect->setChecked(false);
	datum->setText(adate);
	call->setText(acall);
	qslEin->setChecked(true);
	if(strlen(adate) != 0)
		utc->setFocus();
	else
		datum->setFocus();
		
	slotModeSelect(mode->currentItem());
	
	connect(mode,SIGNAL(activated(int)),this,SLOT(slotModeSelect(int)));
	connect(checkButton,SIGNAL(clicked()),this,SLOT(slotCheckQso()));
	connect(okButton,SIGNAL(clicked()),this,SLOT(slotNewOk()));	
}

void QsoEditDlg::createQsoListe(const char *searchcall)
{
	CQso	*qso;
	char qslInfo[8];
	QList<CQso> liste;
		
	qsoListe->clear();
	log->GetQsoListe(searchcall,&liste);
	if(liste.isEmpty())
	{
		(void) new QListViewItem(qsoListe,i18n("No contact yet."));
		return;
	}
	
	liste.first();
	while((qso = liste.current()) != NULL)
	{
		if(qso->GetQslEin())
			strcpy(qslInfo,"Tnx Qsl");
		else
			strcpy(qslInfo,"Pse Qsl");
		(void) new QListViewItem(qsoListe,qso->GetCall(),qso->datum.get(DTAUS_SHORT),qso->utc.get(true),
			banddata.band(qso->GetBand()),modedata.mode(qso->GetMode()),qslInfo);
		via->setText(qso->GetViaCall());
		liste.next();
	}
}

bool QsoEditDlg::checkEntries(void)
{
	CQso *qso;
	QString help;
	
	qso = new CQso();
	if(! qso->datum.insert(datum->text()))
	{
		datum->setFocus();
		KMsgBox::message(NULL,i18n("Qso Editor"),i18n("Unknown date.\nEnter date like ddmmyy or dd.mm.yyyy"));
		delete qso;
		return false;
	}
	if(! qso->utc.insert(utc->text()))
	{
		utc->setFocus();
		KMsgBox::message(NULL,i18n("Qso Editor"),i18n("Unknown UTC time.\nEnter time like hhmm or hh:mm"));
		delete qso;
		return false;
	}
	
	if(! qso->SetCall(call->text()))
	{
		call->setFocus();
		KMsgBox::message(NULL,i18n("Qso Editor"),
			i18n("Unknown Call.\nOnly calls with three or more characters are acceptable."));
		delete qso;
		return false;
	}
	if(! qso->SetRstAus(rstAus->text()))
	{
		rstAus->setFocus();
		KMsgBox::message(NULL,i18n("Qso Editor"),
			i18n("Unknown rst.\nOnly rst with two or more characters are acceptable."));
		delete qso;
		return false;
	}
	if(! qso->SetRstEin(rstEin->text()))
	{
		rstEin->setFocus();
		KMsgBox::message(NULL,i18n("Qso Editor"),
			i18n("Unknown rst.\nOnly rst with two or more characters are acceptable."));
		delete qso;
		return false;
	}
	if(! qso->SetViaCall(via->text()))
	{
		via->setFocus();
		KMsgBox::message(NULL,i18n("Qso Editor"),
			i18n("Unknown Via Call.\nOnly calls with three or more characters are acceptable."));
		delete qso;
		return false;
	}
	
	return true;	// scheint ja alles ok zu sein...
}
	
void QsoEditDlg::checkCallData()		// sind schon Calldaten vorhanden ?
{
	CallEditDlg* cdlg;
	CCall *newcall;
	char dummy[20];
	int ic;
	
	if( (newcall = log->SearchCall(qso)) == NULL)
	{
		cdlg = new CallEditDlg();
		newcall = new CCall();
		newcall->SetCall(qso->GetCall(false,dummy));
		cdlg->SetCallRef(newcall);
		cdlg->setCaption(i18n("Create New Call"));
		if(cdlg->exec() == true)
			log->AddCall(newcall);
		else
			delete newcall;
		delete cdlg;
	}
	else
		if( (ic = newcall->dataComplete(config)) != CALLCHECK_OK)
		{
			CallEditDlg* dlg;
	
			dlg = new CallEditDlg();
			dlg->setCaption(i18n("Edit Call"));
			dlg->SetCallRef(newcall);
			dlg->callChecked(ic);
			dlg->exec();
			delete dlg;
		}			
}
		
		
//
// Signale abarbeiten
//....................

void QsoEditDlg::slotEditOk()
{
	if( !checkEntries())
		return;
	qso->SetCall(call->text());
	qso->SetViaCall(via->text());
	qso->datum.insert(datum->text());
	qso->utc.insert(utc->text());
	qso->SetBand(band->currentItem());
	qso->SetMode(mode->currentItem());
	qso->SetRstEin(rstEin->text());
	qso->SetRstAus(rstAus->text());
	qso->SetQslEin(qslEin->isChecked());
	qso->SetQslAus(qslAus->isChecked());
	qso->SetQslDirekt(qslDirect->isChecked());
	qso->SetQslActivity(qslAktiv->isChecked());
	done(true);
}

void QsoEditDlg::slotNewOk()
{
	if( !checkEntries())
		return;
	config->setGroup("Logging");
	config->writeEntry("Band",band->currentItem());
	config->writeEntry("Mode",mode->currentItem());
	qso->SetCall(call->text());
	qso->SetViaCall(via->text());
	qso->datum.insert(datum->text());
	qso->utc.insert(utc->text());
	qso->SetBand(band->currentItem());
	qso->SetMode(mode->currentItem());
	qso->SetRstEin(rstEin->text());
	qso->SetRstAus(rstAus->text());
	qso->SetQslEin(qslEin->isChecked());
	qso->SetQslAus(qslAus->isChecked());
	qso->SetQslDirekt(qslDirect->isChecked());
	qso->SetQslActivity(qslAktiv->isChecked());
	if(config->readBoolEntry("Check_Call",true))
		checkCallData();
		
	done(true);
}


void QsoEditDlg::slotQslAkt()
{
	qslAus->setEnabled(qslAktiv->isChecked());
	qslEin->setEnabled(qslAktiv->isChecked());
	qslDirect->setEnabled(qslAktiv->isChecked());
	via->setEnabled(qslAktiv->isChecked());
}

void QsoEditDlg::slotModeSelect(int index)
{
	rstEin->setText(modedata.rst(index));
	rstAus->setText(modedata.rst(index));
}

void QsoEditDlg::slotCheckQso()
{
	CQso *qso;
	
	qso = new CQso();
  	if(! qso->SetCall(call->text()))
	{
		call->setFocus();
		KMsgBox::message(NULL,i18n("Qso Editor"),
			i18n("Unknown Call.\nOnly calls with three or more characters are acceptable."));
		delete qso;
	}
   else
   {
   	char dummy[20];
   	createQsoListe(qso->GetCall(false,dummy));
   	delete qso;
		checkButton->setDefault(false);
		okButton->setDefault(true);
   }
}








































