/***************************************************************************
                          qsloutdlg.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Aug 16 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "qsloutdlg.h"
#include <qbuttongroup.h>



QslOutDlg::QslOutDlg(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	
	setCaption(i18n("Outgoing QSLs"));
	group = new QButtonGroup;
	group->insert(allButton,QSLOUT_ALL);
	group->insert(buroButton,QSLOUT_BURO);
	group->insert(direktButton,QSLOUT_DIREKT);
	group->setButton(QSLOUT_ALL);
	
	qsoListe = new LogListView(this);
	qsoListe->setGeometry(20,30,460,200);
	qsoListe->createQslOutView();
	printButton->setEnabled(false);
	cards->setAlignment(AlignCenter);
	
	connect(group,SIGNAL(clicked(int)),this,SLOT(slotAuswahl(int)));	
	connect(okButton,SIGNAL(clicked()),this,SLOT(accept()));
}

QslOutDlg::~QslOutDlg(){
	delete group;
}

void QslOutDlg::Init(LogBook *alog)
{
	log = alog;
	slotAuswahl(QSLOUT_ALL);
};

void QslOutDlg::slotAuswahl(int id)
{
	QListViewItem *oldItem;
	QList<CQso> qsl;
	CQso *qso;
	char qslInfo[10];
	CBand banddata;
	CMode modedata;
	
	oldItem = NULL;
	qsoListe->clear();
	log->GetQslOut(&qsl,id);
	sprintf(qslInfo,"%d",qsl.count());
	cards->setText(qslInfo);
	qsl.first();
	while((qso = qsl.current()))
	{
		if(qso->GetQslEin())
			strcpy(qslInfo,"Tnx Qsl");
		else
			strcpy(qslInfo,"Pse Qsl");
		
		oldItem = new QListViewItem(qsoListe,oldItem,qso->GetCall(),qso->datum.get(DTAUS_SHORT),qso->utc.get(true),
			banddata.band(qso->GetBand()),modedata.mode(qso->GetMode()),qso->GetRstAus(),qslInfo,qso->GetViaCall());
		qsoListe->addItemPointer(oldItem);
		
		qsl.next();
	}
	qsoListe->setSelected(qsoListe->firstChild(),true);
	qsoListe->setFocus();
	
}



















