/***************************************************************************
                          dhlogview.h  -  description                              
                             -------------------                                         
    begin                : Tue Jun 22 17:36:34 MEST 1999
                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DHLOGVIEW_H
#define DHLOGVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <kapp.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qscrollbar.h>
#include <qcheckbox.h>
#include "dhlogdoc.h"
#include "loglabel.h"

class DHLogDoc;

/** The DHLogView class provides the view widget for the DHLogApp instance.	
	* The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As DHLogView is part of the
	* docuement-view model, it needs a reference to the document object connected with it by the DHLogApp class to manipulate and display
	* the document structure provided by the DHLogDoc class.
 	* 	
 	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
 	*/
class DHLogView : public QWidget
{
  Q_OBJECT

public:
  /** Constructor for the main view */
  DHLogView(QWidget* parent = 0, const char* name=0);
  /** Destructor for the main view */
  ~DHLogView();

	/** returns a pointer to the document connected to the view instance. Mind that this method requires a DHLogApp instance as a parent
		* widget to get to the window document pointer by calling the DHLogApp::getDocument() method.
		*
		* @see DHLogApp#getDocument
		*/
	DHLogDoc* getDocument() const;
	
  /** contains the implementation for printing functionality */
	void print(QPrinter* m_pPrinter);
	
   void UpdateView(long nr = -1);
private slots:
	void slotScroll(int nr);
	void slotQslClick();	
		
signals:
	void updEnableMenu();	// wird aufgerufen, um Menues passend zu setzen, ob an oder aus...
private:
	DHLogDoc* logdoc;
	QLabel *lDate, *lUTC, *lCall, *lBand, *lMode, *lRSTout, *lRSTin;
	LogLabel *fDate, *fUTC, *fCall, *fBand, *fMode, *fRSTout, *fRSTin;
	
	QLabel *lName, *lQth, *lDok, *lLocator;
	LogLabel *fName, *fQth, *fDok, *fLocator;

	QLabel *lQslVia, *lQsoNr, *lQsoAnz, *lCallAnz;
	QCheckBox *fQslIn, *fQslOut;
	LogLabel *fQslVia;
		
	QFrame *lFrame1,*lFrame2;
	QScrollBar *fScroller;
	
	long oldqsonr;
	
};

#endif // DHLOGVIEW_H






















