/***************************************************************************
                          xfree.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : lun jan 25 23:02:54 CET 1999
                                           
    copyright            : (C) 1999 by                          
    email                :                                      
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include "xfree.h"
#include <kiconloader.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qpainter.h>
#include "monitor.h"
#include "custon.h"
#include "avance.h"
#include <kconfig.h>
#include "define_kbd.h"
#include <qmessagebox.h>
#include <launcher.h>
#include <qaccel.h>
#include <stdlib.h>
#include <kprocess.h>
#include <kapp.h>

extern const char *vendeur[];

Xfree::Xfree(QWidget*parent,const char* name):QWidget(parent,name)
{
  int i;
  ListeVirtual = new QStrList();
  init_struct();
  MoniteurCourant=0;
  QFont font;
  font.setBold(true);
  setCaption(klocale->translate("X Server Configuration")); /*"Configuration du serveur X"));*/
  setMaximumSize(440,480);
  setMinimumSize(440,480);
  
  QFrame * bas= new QFrame(this);
  bas -> setFrameStyle(QFrame::Panel|QFrame::Raised);
  bas -> setGeometry(QRect(0,10,440,420));

/* ajout de bouton ok ... */
  ok = new QPushButton(this);
  ok -> setGeometry(200,445,70,25);
  ok -> setText("&Ok");
  connect(ok, SIGNAL(clicked()), SLOT(slotok()));
  ok->setAccel(Key_Enter);
  ok->setAccel(Key_Return);

  test = new QPushButton(this);
  test -> setGeometry(280,445,70,25);
  test -> setText(klocale->translate("&Try.."));
  connect(test, SIGNAL( clicked()) , SLOT (slotApply()));


  annul = new QPushButton(this);
  annul -> setGeometry(360,445,70,25);
  annul -> setText(klocale->translate("&Cancel"));
  connect(annul, SIGNAL(clicked()), SLOT(slotquit()));
  annul -> setAccel(Key_Escape);

  moniteur = new QLabel(bas);
  moniteur -> setPixmap(Icon("640x480.xpm"));
  moniteur -> setGeometry(120,10,200,180);
  moniteur -> show();  
  
  QLabel * ListeMoniteur = new QLabel(bas);
  ListeMoniteur -> setFont (font);
  ListeMoniteur -> setText(klocale->translate("Monitor"));/*Ecran");*/
  ListeMoniteur -> setGeometry(5,190,45,20);
  
/*affichage du type de moniteur */
  ComMoniteur = new QComboBox(bas);
  ComMoniteur -> setGeometry(55,190,375,20);
  for (i=0; i<11;i++)
     ComMoniteur -> insertItem(SDefMonitor[i]. Id);
 // ComMoniteur -> insertItem("Personnalis ..... ");
  connect( ComMoniteur, SIGNAL( activated(int )), SLOT(slotMonitorChanged(int )) );

/* affichage des info de frequence de balyage */
  QFrame * FrFrBal = new QFrame(bas);
  FrFrBal -> setFrameStyle(QFrame :: Box | QFrame :: Sunken);
  FrFrBal -> setGeometry(160,220,270,50);
    
    
  QLabel *LTHSync = new QLabel(bas);
  LTHSync -> setFont(font);
  LTHSync -> setText(klocale->translate("Scanning frequency"));
  LTHSync -> setGeometry(15,225,140,20);
    
  QLabel * HText = new QLabel(bas);
  HText -> setText(klocale->translate("Horizontal VSync (Khz)"));
  HText -> setGeometry(170,225,140,20);
  
  QLabel * VText = new QLabel(bas);
  VText -> setText(klocale->translate("Verticale HSync (Hz)"));
  VText -> setGeometry(170,245,130,20);
    
  LHSync = new QLabel(bas);
  LHSync -> setText( SDefMonitor[0].Hsync);
  LHSync -> setGeometry(320,225,100,20);
 
  LVSync = new QLabel(bas);
  LVSync -> setText ( SDefMonitor[0].Vsync );
  LVSync -> setGeometry(320,245,100,20);
          
  QFrame * FCouleur = new QFrame(bas);
  FCouleur -> setFrameStyle(QFrame ::Box | QFrame :: Sunken);
  FCouleur -> setGeometry(10,280,200,100);
  
  QFrame * FTaille = new QFrame(bas);
  FTaille -> setFrameStyle (QFrame :: Box | QFrame ::Sunken);
  FTaille -> setGeometry (230,280,200,100);
  
  QLabel * Couleur = new QLabel ( bas);
  Couleur -> setFont(font);
  Couleur ->setText(klocale->translate(" Colors "));
  Couleur -> setGeometry(20 ,275,strlen(klocale->translate(" Colors "))*6/*125*/,10);
   
  PixCouleur = new QLabel (bas);
  PixCouleur -> setPixmap(Icon("couleur256.xpm"));
  PixCouleur -> setGeometry(20,300,180,20);
  
  NbCouleur = new QComboBox(bas);
  NbCouleur ->setGeometry(20,330,180,20);
  NbCouleur -> insertItem(klocale->translate(" 8 Bits - 256 Colors"));
  NbCouleur -> insertItem(klocale->translate("16 Bits - 65 000 Colors"));
  NbCouleur -> insertItem(klocale->translate("24 Bits - 16 M Colors"));
  NbCouleur -> insertItem(klocale->translate("32 Bits - 16 M Coleurs"));
  connect( NbCouleur, SIGNAL( activated(int )), SLOT(slotCouleurChanged(int )) );
  
  Resolution = new QSlider(QSlider::Horizontal,bas);
  Resolution -> setGeometry(240,300,180,15);
  Resolution -> setRange (0,SDefMonitor[0].Resol->count()-1 );
  Resolution -> setSteps(1,1);
  Resolution -> setEnabled(FALSE);
  Resolution -> setTickmarks ( QSlider::NoMarks);
  connect( Resolution, SIGNAL(valueChanged(int)), SLOT(resolution_change(int)) );
  
  LResolution = new QLabel (bas);
  LResolution -> setText(SDefMonitor[0].Resol->first());
  LResolution -> setGeometry(240,315,180,12);
  LResolution -> setAlignment (AlignCenter);
 
  LVirtual = new QLabel (bas);
  LVirtual -> setText(klocale->translate("None"));
  LVirtual -> setGeometry(240,330,180,12);
  LVirtual -> setAlignment (AlignCenter);
  
  QLabel * LRes = new QLabel (bas);
  LRes -> setFont(font);
  LRes -> setText(klocale->translate("Desktop"));
  LRes -> setGeometry(240,285,180,16);
  LRes -> setAlignment(AlignCenter);

  QLabel * LVir = new QLabel (bas);
  LVir -> setFont( font  );
  LVir -> setText(klocale->translate("Virtual Desktop"));
  LVir -> setGeometry(240,360,180,16);
  LVir -> setAlignment(AlignCenter);

  ChkVirtual = new QCheckBox(klocale->translate("Enable Virtual Desktop"),bas);
  ChkVirtual -> setGeometry(10,390,150,20);
  connect(ChkVirtual,SIGNAL( toggled (bool)),   SLOT(slotVirtualActive(bool )));

  Virtual= new QSlider(QSlider::Horizontal,bas);
  Virtual -> setGeometry(240,344,180,15);
  Virtual -> setRange (0,ListeVirtual->count()-1 );
  Virtual -> setSteps(1,1);
  Virtual -> setEnabled(FALSE);
  Virtual -> setTickmarks ( QSlider::NoMarks);
  connect( Virtual, SIGNAL(valueChanged(int)), SLOT(slotVirtualChange(int)) );
  

  /* bouton avanc*/
  QPushButton * avance = new QPushButton(bas);
  avance -> setText(klocale->translate("Avanced"));
  avance -> setGeometry(340,386,90,25);
  connect (avance, SIGNAL (clicked()), SLOT (slotcustomisation()));

/*chagement des donnes*/
  KConfig * fichier = new KConfig ( 0L,"xfreeconfig");
  fichier->setGroup("General");
/*nb couleur*/
  NbCouleur->setCurrentItem(fichier -> readNumEntry("idNbColor",(int)NbCouleur->currentItem()));
  if( (NbCouleur->currentItem()) == 0)
    PixCouleur->setPixmap(Icon("couleur256.xpm"));
  else
    PixCouleur->setPixmap(Icon("couleur.xpm"));

 MMarque= fichier->readEntry("Marque");
  ComMoniteur->setCurrentItem(fichier -> readNumEntry("idMonitor"));
  fichier->readListEntry("ListeResol",*SDefMonitor[ComMoniteur->currentItem()].Resol,';');
  ChkVirtual->setChecked(fichier -> readBoolEntry("Virtual"));
  Virtual->setValue(fichier -> readNumEntry("idVirtual"));
  Resolution -> setRange (0,SDefMonitor[ComMoniteur->currentItem()].Resol->count()-1 );

  Resolution -> setValue(fichier->readNumEntry("Resolution"));
 if(fichier->readBoolEntry("ResSlider"))
    Resolution -> setTickmarks ( QSlider::Below);
if(ComMoniteur->currentItem()!=0)
{
  SDefMonitor[ComMoniteur->currentItem()].Hsync=fichier->readEntry("HSync") ;
  SDefMonitor[ComMoniteur->currentItem()].Vsync=fichier->readEntry("VSync");
  LHSync -> setText( SDefMonitor[ComMoniteur->currentItem()].Hsync);
  LVSync -> setText ( SDefMonitor[ComMoniteur->currentItem()].Vsync );
}
  MoniteurCourant=ComMoniteur->currentItem();
  MType = fichier ->readEntry("MType");
  if(MoniteurCourant==10)
   SDefMonitor[10].Id=MType;
  if (SDefMonitor[ComMoniteur->currentItem()].Resol->count()>0)
    Resolution ->setEnabled(TRUE);


 fichier->setGroup("Device");
 if( ! strcmp(fichier->readEntry("Server"),"XF86_VGA16" ) )
 {
   NbCouleur->setEnabled(FALSE);
   PixCouleur->setPixmap(Icon("couleur16.xpm"));
   Resolution->setEnabled(FALSE);
   Resolution->setValue(0);
   Resolution->setTickmarks ( QSlider::NoMarks);
 }



  delete fichier;




  modified=FALSE;

}
Xfree::~Xfree(){
}

void Xfree::resolution_change(int i)
{

  QString pixmap;
  pixmap.sprintf( "%s.xpm",SDefMonitor[ComMoniteur -> currentItem()].Resol->at(i) );
  LResolution ->setText(SDefMonitor[ComMoniteur -> currentItem()].Resol->at(i));
  moniteur -> setPixmap(Icon(pixmap.data()));

 if (Virtual -> isEnabled())
  if (i >=Virtual -> value())
    if( ComMoniteur -> currentItem() == 2 )
       Virtual -> setValue(i+1);
    else
       Virtual -> setValue(i);



}

/*met a jout le slider avec le changement des specif de l'ecran*/
void Xfree::slotMonitorChanged(int  rang)
{
  modified=TRUE;
  if(rang != 10)
  {
   MoniteurCourant = ComMoniteur ->currentItem();
   if (rang ==0)
   {
    Resolution -> setEnabled(FALSE);
    Resolution -> setTickmarks ( QSlider::NoMarks);
    Resolution -> setValue (0);
    LHSync -> setText( SDefMonitor[rang].Hsync);
    LVSync -> setText( SDefMonitor[rang].Vsync);
   }
   else
   {
    Resolution -> setEnabled(TRUE);
    Resolution -> setRange (0,SDefMonitor[rang].Resol->count()-1);
    Resolution -> setValue(0);  
    Resolution -> setTickmarks ( QSlider::Below);                 /* y a peut-tre a mettre les 2 dernier apres '}' */
    LHSync -> setText( SDefMonitor[rang].Hsync);
    LVSync -> setText( SDefMonitor[rang].Vsync);
   }
  }
  else
  {
    custom *pers = new custom(MMarque,SDefMonitor[10].Id,SDefMonitor[10].Hsync, SDefMonitor[10].Vsync , SDefMonitor[10].Resol->at(SDefMonitor[10].Resol->count()-1) );
    if( pers->exec())
    {
      /*mise a jours des champs*/
      delete SDefMonitor[10].Resol;

      SDefMonitor[10].Hsync=pers -> ValueHSync();
      SDefMonitor[10].Vsync=pers -> ValueVSync();
      LHSync -> setText(SDefMonitor[10].Hsync);
      LVSync -> setText(SDefMonitor[10].Vsync);
      MMarque = pers->MMarque();
      SDefMonitor[10].Id = pers -> MType();
      if (MType !="") {ComMoniteur -> changeItem(SDefMonitor[10].Id,10) ;  ComMoniteur->repaint()  ;}
/*ajout des resolutions dans le slider*/
       QString tmpRes = pers->ResMax();
       if (tmpRes == "640x480")
       {
         Resolution -> setEnabled(FALSE);
         Resolution -> setTickmarks (QSlider :: NoMarks);
         Resolution -> setValue (0);
         SDefMonitor[10].Resol=new QStrList();
         SDefMonitor[10].Resol->insert(0,"640x480");
       }
       else
       {
          Resolution -> setEnabled(TRUE);
          Resolution -> setTickmarks(QSlider :: Below);
          if (tmpRes ==   "800x600")
           {
                Resolution -> setRange(0,1);
                SDefMonitor[10].Resol=new QStrList();
                SDefMonitor[10].Resol->insert(0,"640x480");
                SDefMonitor[10].Resol->insert(1,"800x600");
            }
          if (tmpRes ==  "1024x768")
            {
                 Resolution -> setRange(0,2);
                 SDefMonitor[10].Resol=new QStrList();
                 SDefMonitor[10].Resol->insert(0,"640x480");
                 SDefMonitor[10].Resol->insert(1,"800x600");
                 SDefMonitor[10].Resol->insert(2,"1024x768");
            }
          if (tmpRes ==  "1152x864")
          {
                 Resolution -> setRange(0,3);
                 SDefMonitor[10].Resol=new QStrList();
                 SDefMonitor[10].Resol->insert(0,"640x480");
                 SDefMonitor[10].Resol->insert(1,"800x600");
                 SDefMonitor[10].Resol->insert(2,"1024x768");
                 SDefMonitor[10].Resol->insert(3,"1152x864");
           }
          if (tmpRes == "1280x1024")
          {
                 Resolution -> setRange(0,4);
                 SDefMonitor[10].Resol=new QStrList();
                 SDefMonitor[10].Resol->insert(0,"640x480");
                 SDefMonitor[10].Resol->insert(1,"800x600");
                 SDefMonitor[10].Resol->insert(2,"1024x768");
                 SDefMonitor[10].Resol->insert(3,"1152x864");
                 SDefMonitor[10].Resol->insert(4,"1280x1024");
           }
          if (tmpRes == "1600x1200")
          {
                Resolution -> setRange(0,5);
                 SDefMonitor[10].Resol=new QStrList();
                 SDefMonitor[10].Resol->insert(0,"640x480");
                 SDefMonitor[10].Resol->insert(1,"800x600");
                 SDefMonitor[10].Resol->insert(2,"1024x768");
                 SDefMonitor[10].Resol->insert(3,"1152x864");
                 SDefMonitor[10].Resol->insert(4,"1280x1024");
                 SDefMonitor[10].Resol->insert(5,"1600x1200");
          }
       }
      delete pers;
    }
    else
      ComMoniteur ->setCurrentItem(MoniteurCourant) ;

  }
}
 


void Xfree::init_struct()
{
 SDefMonitor[0].Resol= new QStrList();
 SDefMonitor[0].Resol->insert(0,"640x480");
 
 SDefMonitor[1].Resol=new QStrList();
 SDefMonitor[1].Resol->insert(0,"640x480");
 SDefMonitor[1].Resol->insert(1,"800x600");

 
 SDefMonitor[2].Resol=new QStrList();
 SDefMonitor[2].Resol->insert(0,"640x480");
 SDefMonitor[2].Resol->insert(1,"1024x768");
 
 SDefMonitor[3].Resol=new QStrList();
 SDefMonitor[3].Resol->insert(0,"640x480");
 SDefMonitor[3].Resol->insert(1,"800x600");
 SDefMonitor[3].Resol->insert(2,"1024x768");
 
 SDefMonitor[4].Resol=new QStrList();
 SDefMonitor[4].Resol->insert(0,"640x480");
 SDefMonitor[4].Resol->insert(1,"800x600");
 SDefMonitor[4].Resol->insert(2,"1024x768");
 
 SDefMonitor[5].Resol=new QStrList();
 SDefMonitor[5].Resol->insert(0,"640x480");
 SDefMonitor[5].Resol->insert(1,"800x600");
 SDefMonitor[5].Resol->insert(2,"1024x768");
 
 SDefMonitor[6].Resol=new QStrList();
 SDefMonitor[6].Resol->insert(0,"640x480");
 SDefMonitor[6].Resol->insert(1,"800x600");
 SDefMonitor[6].Resol->insert(2,"1024x768");
 
 SDefMonitor[7].Resol=new QStrList();
 SDefMonitor[7].Resol->insert(0,"640x480");
 SDefMonitor[7].Resol->insert(1,"800x600");
 SDefMonitor[7].Resol->insert(2,"1024x768");
 SDefMonitor[7].Resol->insert(3,"1152x864");
 SDefMonitor[7].Resol->insert(4,"1280x1024");
 
 SDefMonitor[8].Resol=new QStrList();
 SDefMonitor[8].Resol->insert(0,"640x480");
 SDefMonitor[8].Resol->insert(1,"800x600");
 SDefMonitor[8].Resol->insert(2,"1024x768");
 SDefMonitor[8].Resol->insert(3,"1152x864");
 SDefMonitor[8].Resol->insert(4,"1280x1024");
 
 SDefMonitor[9].Resol=new QStrList();
 SDefMonitor[9].Resol->insert(0,"640x480");
 SDefMonitor[9].Resol->insert(1,"800x600");
 SDefMonitor[9].Resol->insert(2,"1024x768");
 SDefMonitor[9].Resol->insert(3,"1152x864");
 SDefMonitor[9].Resol->insert(4,"1280x1024");

 SDefMonitor[10].Resol=new QStrList();
 SDefMonitor[10].Resol->insert(0,"640x480");

 ListeVirtual->insert(0,"640x480");
 ListeVirtual->insert(1,"800x600");
 ListeVirtual->insert(2,"1024x768");
 ListeVirtual->insert(3,"1152x864");
 ListeVirtual->insert(4,"1280x1024");
 ListeVirtual->insert(5,"1600x1200");
 ListeVirtual->insert(6,"1800x1440");
}

void Xfree::slotVirtualActive(bool actif)
{
 modified=TRUE;
 if(actif)
 {
   /* met le slider actif et le met en pos maxi */
   Virtual -> setEnabled(TRUE);
   Virtual -> setTickmarks ( QSlider::Above);
   Virtual -> setValue(ListeVirtual->count() -1);
 }
 else
 { /* desaltive le slider et on le met en pos 0 */
   Virtual -> setEnabled(FALSE);
   Virtual -> setTickmarks ( QSlider::NoMarks);
   Virtual -> setValue (0);
   LVirtual -> setText(klocale->translate("None"));
 }
}

void Xfree::slotVirtualChange(int i)
{
  modified=TRUE;
   if( Virtual -> isEnabled())
   {
     if(i <= Resolution->value() )
       if( ComMoniteur -> currentItem() == 2 )
           Resolution-> setValue(i-1);
       else
           Resolution-> setValue(i);
      LVirtual -> setText(ListeVirtual->at(i));
    }
   else
     LVirtual -> setText(klocale->translate("None"));
      
}

void Xfree::slotCouleurChanged(int i)
{
  modified=TRUE;
  if( i == 0)
    PixCouleur->setPixmap(Icon("couleur256.xpm"));
  else
    PixCouleur->setPixmap(Icon("couleur.xpm"));
}

/*bouton avanc clicked**/
void Xfree::slotcustomisation()
{

  modified=TRUE;
 Avance * did = new  Avance();
  did->exec();

 KConfig * fichier = new KConfig(0L,"xfreeconfig");
 fichier->setGroup("Device");
 if( ! strcmp(fichier->readEntry("Server"),"XF86_VGA16" ) )
 {
   NbCouleur->setEnabled(FALSE);
   PixCouleur->setPixmap(Icon("couleur16.xpm"));
   Resolution->setEnabled(FALSE);
   Resolution->setValue(0);
   Resolution->setTickmarks ( QSlider::NoMarks);
 }
 else
 {
   NbCouleur->setEnabled(TRUE);
   if( NbCouleur->currentItem() == 0 )
      PixCouleur->setPixmap(Icon("couleur256.xpm"));
   else
       PixCouleur->setPixmap(Icon("couleur.xpm"));

   Resolution->setEnabled(TRUE);
   Resolution->setTickmarks ( QSlider::Below );
 }

   delete fichier;


}


void Xfree::writeconfig()
{
  KConfig * fichier = new KConfig ( 0L,"xfreeconfig");
  fichier->setGroup("General");
/*nb couleur*/
  fichier -> writeEntry("idNbColor",(int)NbCouleur->currentItem());
/*def nomiteur*/
  fichier -> writeEntry("idMonitor",(int)ComMoniteur->currentItem());
  fichier -> writeEntry("Marque",MMarque);
  fichier -> writeEntry("MType",/*MType*/SDefMonitor[ComMoniteur->currentItem()].Id);
  fichier -> writeEntry("Resolution",Resolution->value());
  fichier -> writeEntry("ListeResol",*SDefMonitor[ComMoniteur->currentItem()].Resol,';');
  fichier -> writeEntry("Virtual", ChkVirtual->isChecked());
  fichier -> writeEntry("idVirtual", Virtual->value());
  fichier -> writeEntry("ResSlider",Resolution->isEnabled());
  fichier -> writeEntry("HSync", SDefMonitor[ComMoniteur->currentItem()].Hsync);
  fichier -> writeEntry("VSync",  SDefMonitor[ComMoniteur->currentItem()].Vsync);
  delete fichier;


  QMessageBox::information(this,klocale->translate("XF86Config file localisation"),
                klocale->translate("The XF86Config file is in \n/usr/X11R6/lib/X11\n"
                                "the last file was renamed in XF86Conifg.old"), klocale->translate("&Ok"));
  system("mv -f /usr/X11R6/lib/X11/XF86Config /usr/X11R6/lib/X11/XF86Config.old");
  system("cp -f /tmp/XF86Config /usr/X11R6/lib/X11/XF86Config");
//      "Le fichier XF86Config a t plac dans\n/usr/X11R6/lib/X11\n"
//le prcdent a t renomm en XF86Config.old"


}







void Xfree::slotApply()
{

  KConfig *fichier = new KConfig ("xfreerc","xfreeconfig");
//"Erreur de serveur"
//Aucune carte graphique n'est dfinie ...
  fichier->setGroup("Device");
  if (strlen(fichier->readEntry("Server").data()) == 0)
    QMessageBox::warning(this,klocale->translate("Error"),klocale->translate("No Device devine ..."),klocale->translate("&Ok"),0,0);
  else
 {
  modified=FALSE;
  QStrList  ListeFonte;
  FILE * XF86Config = fopen ("/tmp/XF86Config","w");

  /* generation du fichier XF86Config*/
/*section file*/
  fprintf(XF86Config,"Section \"Files\"\n");
  fprintf(XF86Config,"    RgbPath    \"/usr/X11R6/lib/X11/rgb\"\n");
  fprintf(XF86Config,"#    ModulePath \"/usr/X11R6/lib/modules\"\n");
/*config des fonts*/
  fichier -> setGroup("Fonts");
  fichier -> readListEntry( "FontPath", ListeFonte , ';');
  if( ListeFonte.count() > 0 )
  {
    for (unsigned int n = 0; n < ListeFonte.count() ; n++)
     fprintf(XF86Config,"    FontPath   \"%s\"\n",ListeFonte.at(n));
  }
  fprintf(XF86Config,"EndSection\n\n");


/*section serveur FLAGS*/
  fprintf(XF86Config,"Section \"ServerFlags\"\n");
  fprintf(XF86Config,"#    NoTrapSignals\n");
  fprintf(XF86Config,"#    DontZap\n");
  fprintf(XF86Config,"#    DontZoom\n");
  fprintf(XF86Config,"#    DisableVidModeExtension\n");
  fprintf(XF86Config,"EndSection\n\n");


/*section inputs*/
/*section keyboard*/
  fichier->setGroup("Keyboard");
  fprintf(XF86Config,"Section \"Keyboard\"\n");
  fprintf(XF86Config,"    Protocol	\"Standard\"\n");
  fprintf(XF86Config,"    XkbRules    \"xfree86\"\n");
  fprintf(XF86Config,"    XkbModel    \"%s\"\n",Model[(fichier->readNumEntry("idXkbModel"))]);
  fprintf(XF86Config,"    XkbLayout   \"%s\"\n",Layout[fichier->readNumEntry("idXkbLayout")]);
  fprintf(XF86Config,"    XkbKeymap   \"xfree86(%s)\"\n",Layout[fichier->readNumEntry("idXkbLayout")]);
  fprintf(XF86Config,"EndSection\n\n");
/*section mouse*/
  fichier->setGroup("Mouse");
  fprintf(XF86Config,"Section \"Pointer\"\n");
  fprintf(XF86Config,"    Protocol    \"%s\"\n",fichier->readEntry("Protocol").data());
  fprintf(XF86Config,"    Device      \"%s\"\n",fichier->readEntry("Device").data());
  if (!fichier->readBoolEntry("Emulate3Buttons") )
    fprintf(XF86Config,"#");
  fprintf(XF86Config,"    Emulate3Buttons\n");
  fprintf(XF86Config,"    Emulate3Timeout    %s\n",fichier->readEntry("Emulate3Timeout").data());
  fprintf(XF86Config,"EndSection\n\n");

/*section Monitor*/
  fprintf(XF86Config,"Section  \"Monitor\"\n");
  fprintf(XF86Config,"    Identifier  \"My Monitor\"\n");
 /*description moniteur texte*/
  fprintf(XF86Config,"    VendorName  \"Unknown\"\n");
  fprintf(XF86Config,"    ModelName   \"Unknown\"\n");

 /*frequence*/
  fprintf(XF86Config,"    HorizSync   %s\n",LHSync->text());
  fprintf(XF86Config,"    VertRefresh %s\n",LVSync->text());
 /*modeline*/
  fichier->setGroup("Modeline");
  QString tmp;
  QString l;
   for (int n=0 ; n<fichier ->readNumEntry("NbLine"); n++)
   {
     tmp.sprintf("Line%d",n);
     l=fichier->readEntry(tmp.data());
     fprintf(XF86Config,"%s\n",l.data());
   }
  fprintf(XF86Config,"EndSection\n\n");

/*section device*/
  fichier->setGroup("Device");
  fprintf(XF86Config,"Section \"Device\"\n");
  fprintf(XF86Config,"    Identifier  \"My Video Card\"\n");
  fprintf(XF86Config,"    VendorName  \"%s\"\n",vendeur[fichier->readNumEntry("idVendor")]);
  fprintf(XF86Config,"    BoardName   \"%s\"\n",fichier->readEntry("Modele").data());
  if(fichier->readNumEntry("idMem")!=0)
    fprintf(XF86Config,"    VideoRam    %s\n",fichier->readEntry("Mem").data());
  fprintf(XF86Config,"EndSection\n\n");

/*section screen*/
/******************************************************************/
/*                  mode svga                                     */
  fprintf(XF86Config,"Section \"Screen\"\n");
  fprintf(XF86Config,"    Driver      \"svga\"\n");
  fprintf(XF86Config,"    Device      \"My Video Card\"\n");
  fprintf(XF86Config,"    Monitor     \"My Monitor\"\n");
/*section dpms*/
  fichier->setGroup("Energy");
  if(fichier->readBoolEntry("Dpms") )
  {
    fprintf(XF86Config,"    StandbyTime    %s\n",fichier->readEntry("Standby").data());
    fprintf(XF86Config,"    BlankTime      %s\n",fichier->readEntry("Off").data());
    fprintf(XF86Config,"    SuspendTime    %s\n",fichier->readEntry("Suspend").data());
  }
/*subsection*/
  fprintf(XF86Config,"    Subsection \"Display\"\n");
  fprintf(XF86Config,"        Depth       ");
  switch (NbCouleur->currentItem())
  {
    case 0 : fprintf(XF86Config,"8\n"); break;
    case 1 : fprintf(XF86Config,"16\n");break;
    case 2 : fprintf(XF86Config,"24\n");break;
    case 3 : fprintf(XF86Config,"32\n");break;
  }
  fprintf(XF86Config,"        Modes       ");
/*affichage des resolution*/                                      /*\/ slider*/
//  fprintf(XF86Config,"\"%s\"",SDefMonitor[ComMoniteur -> currentItem()].Resol->at(Resolution->value() ) );
  int step= Resolution-> value();
  while (step >-1 /*< Resolution-> value()*/)
  {
     fprintf(XF86Config," \"%s\"",SDefMonitor[ComMoniteur -> currentItem()].Resol->at( step ) );
     step-=1;
  }
  fprintf(XF86Config,"\n");

/*affichage virtuel*/
  if (ChkVirtual->isChecked())
  {
    fprintf(XF86Config,"        Virtual     ");
    QString tmpVirtuel = ListeVirtual->at( Virtual->value() );
    tmpVirtuel.replace(tmpVirtuel.find('x'),1," ");
    fprintf(XF86Config,"%s\n",tmpVirtuel.data());
  }
  fprintf(XF86Config,"    EndSubsection\n\n");
  fprintf(XF86Config,"EndSection\n\n");

/*******************************************************/
/*              mode vga stndard                       */
  fprintf(XF86Config,"Section \"Screen\"\n");
  fprintf(XF86Config,"    Driver      \"vga16\"\n");
  fprintf(XF86Config,"    Device      \"My Video Card\"\n");
  fprintf(XF86Config,"    Monitor     \"My Monitor\"\n");
 /*section dpms*/
  fichier->setGroup("Energy");
  if(fichier->readBoolEntry("Dpms") )
  {
    fprintf(XF86Config,"    StandbyTime    %s\n",fichier->readEntry("Standby").data());
    fprintf(XF86Config,"    BlankTime      %s\n",fichier->readEntry("Off").data());
    fprintf(XF86Config,"    SuspendTime    %s\n",fichier->readEntry("Suspend").data());
  }
  fprintf(XF86Config,"    Subsection \"Display\"\n");
  fprintf(XF86Config,"        Modes    \"640x480\"\n");
  if (ChkVirtual->isChecked())
  {
    fprintf(XF86Config,"        Virtual     ");
    QString tmpVirtuel = ListeVirtual->at( Virtual->value() );
    tmpVirtuel.replace(tmpVirtuel.find('x'),1," ");
    fprintf(XF86Config,"%s\n",tmpVirtuel.data());
  }

  fprintf(XF86Config,"    EndSubsection\n");
  fprintf(XF86Config,"EndSection\n");

/********************************************************/
/*                 server accel                         */
  fprintf(XF86Config,"Section \"Screen\"\n");
  fprintf(XF86Config,"    Driver      \"accel\"\n");
  fprintf(XF86Config,"    Device      \"My Video Card\"\n");
  fprintf(XF86Config,"    Monitor     \"My Monitor\"\n");
/*section dpms*/
  fichier->setGroup("Energy");
  if(fichier->readBoolEntry("Dpms") )
  {
    fprintf(XF86Config,"    StandbyTime    %s\n",fichier->readEntry("Standby").data());
    fprintf(XF86Config,"    BlankTime      %s\n",fichier->readEntry("Off").data());
    fprintf(XF86Config,"    SuspendTime    %s\n",fichier->readEntry("Suspend").data());
  }
/*subsection*/
  fprintf(XF86Config,"    Subsection \"Display\"\n");
  fprintf(XF86Config,"        Depth       ");
  switch (NbCouleur->currentItem())
  {
    case 0 : fprintf(XF86Config,"8\n"); break;
    case 1 : fprintf(XF86Config,"16\n");break;
    case 2 : fprintf(XF86Config,"24\n");break;
    case 3 : fprintf(XF86Config,"32\n");break;
  }
  fprintf(XF86Config,"        Modes       ");
/*affichage des resolution*/                                      /*\/ slider*/
//  fprintf(XF86Config,"\"%s\"",SDefMonitor[ComMoniteur -> currentItem()].Resol->at(Resolution->value() ) );
  step= Resolution-> value();
  while (step >-1 /*< Resolution-> value()*/)
  {
     fprintf(XF86Config," \"%s\"",SDefMonitor[ComMoniteur -> currentItem()].Resol->at( step ) );
     step-=1;
  }
  fprintf(XF86Config,"\n");

/*affichage virtuel*/
  if (ChkVirtual->isChecked())
  {
    fprintf(XF86Config,"        Virtual     ");
    QString tmpVirtuel = ListeVirtual->at( Virtual->value() );
    tmpVirtuel.replace(tmpVirtuel.find('x'),1," ");
    fprintf(XF86Config,"%s\n",tmpVirtuel.data());
  }
  fprintf(XF86Config,"    EndSubsection\n\n");
  fprintf(XF86Config,"EndSection\n\n");

/*ferneture du fichier XF86conig*/
  fclose(XF86Config);

   Launcher XLauncher;
   XLauncher.exec();
 }
 delete fichier;

}





void Xfree::slotquit()
{
 kapp->quit();
}

void Xfree::slotok()
{
 if(modified) QMessageBox::information(this,
   kapp->klocale->translate("Error"),
   kapp->klocale->translate("You need try the new configuration before"));
 else
 {
   writeconfig();
   kapp->quit();
 }
}





































