/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __PROPGENTAB_H
#define __PROPGENTAB_H

#include <qgroupbox.h>
#include <qlabel.h>
#include <qwidget.h>

#include "device.h"
#include "devtitle.h"


class GeneralPropertiesTab : public QWidget
{
  Q_OBJECT
  
  public:
  
    GeneralPropertiesTab(Device *, QWidget *parent = 0L, const char *name = 0L);
    ~GeneralPropertiesTab() {}

  protected:
  
    void  resizeEvent(QResizeEvent *);

  private:
  
    DeviceTitle  *_devtitle;
    QLabel       *_desclabel, *_infolabel;
    QGroupBox    *_readygbox;
    QLabel       *_readylabel;
    
    Device       *_device;
};


#endif
