/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <kapp.h>

#include "propgentab.h"


GeneralPropertiesTab::GeneralPropertiesTab(Device *device, QWidget *parent, 
					   const char *name) : QWidget(parent, name),
					   		       _device(device)
{
  QString  devname   = _device->deviceName();
  QString  classname = _device->deviceClassName();
  QString  statustext;
  
  if (!classname.isEmpty()) devname += " ("+classname+")";
  
  _devtitle   = new DeviceTitle(_device->bigPixmapFile(), devname, this, "devtitle");
    
  _desclabel  = new QLabel(i18n("Device type:\nManufacturer:"), this, "desclabel");
  _desclabel->adjustSize();

  _infolabel  = new QLabel(_device->deviceBaseClassName()+'\n'+_device->vendorName(), this, "infolabel");
  _infolabel->adjustSize();

  _readygbox  = new QGroupBox(i18n("Device state"), this, "readygbox");

  _readylabel = new QLabel(_readygbox, "readylabel");  
  
  if (_device->deviceState() == Device::DeviceStateReady) statustext = i18n("This device is operational.");
  else                                                    statustext = i18n("No status information available.");
  
  _readylabel->setText(statustext.data());
  _readylabel->setAlignment(WordBreak); 
}


/*
 * Protected methods
 ********************/
 
void  GeneralPropertiesTab::resizeEvent(QResizeEvent *)
{
  uint  margin = 16;
  uint  w      = width();
  uint  h      = height();
  uint  descy  = ((uint) (0.5*margin))+50;
  uint  statey = descy+_desclabel->height()+((uint) (0.75*margin));
  uint  statew = w-2*margin;
  uint  stateh = h-descy-130;
  uint  infow  = statew-2*margin;
  uint  infoh  = stateh-2*margin;
  
  _devtitle->setGeometry(margin, margin, w-2*margin, 50);
  
  _desclabel->move(margin, descy);
  _infolabel->move(2*margin+_desclabel->width(), descy);
  
  _readygbox->setGeometry(margin, statey, statew, stateh);
  _readylabel->setGeometry(margin, ((uint) (1.5*margin)), infow, infoh);
}
