/***************************************************************************
    $Id: startup.cpp,v 1.1 1999/09/26 15:49:53 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: startup.cpp,v $
    Revision 1.1  1999/09/26 15:49:53  stephan
    Added pages for startup and removing.

    Revision 1.2  1999/08/27 16:21:21  wdl
    Standard Headers

 ***************************************************************************/

#include "startup.h"

Startup::Startup(QWidget *parent, const char *name ) : QWidget(parent,name) {
	resize(400,400);
	help = new HTMLHelp(this);
	help->setGeometry(0,10,390,350);
	help->showHelp("startup.html");
	HTMLHelp *add_help = new HTMLHelp(this);
	add_help->setGeometry(120,120,180,80);
	add_help->showHelp("startup_add.html");
	addButton = new QPushButton(this);
	addButton->setGeometry(40,130,60,60);
	addButton->setPixmap(QPixmap(kapp->kde_icondir() + "/printer.xpm"));
	HTMLHelp *rmv_help = new HTMLHelp(this);
	rmv_help->setGeometry(120,210,180,80);
	rmv_help->showHelp("startup_rmv.html");
	rmvButton = new QPushButton(this);
	rmvButton->setGeometry(40,220,60,60);
	rmvButton->setPixmap(QPixmap(kapp->kde_icondir() + "/kfm_trash.xpm"));
	cancelButton = new QPushButton(i18n("Cancel"),this);
	cancelButton->setGeometry(310,365,80,25);
	connect(cancelButton,SIGNAL(clicked()),SLOT(cancel()));
	connect(addButton,SIGNAL(clicked()),SLOT(add()));
	connect(rmvButton,SIGNAL(clicked()),SLOT(rmv()));
}

Startup::~Startup(){
}

void Startup::cancel(){
 kapp->quit();
}

void Startup::rmv(){
	hide();
	kapp->setTopWidget(new KpcRemoveWizard());
}

void Startup::add(){
	hide();
	kapp->setTopWidget(new KpcWizard());
}





