/***************************************************************************
    $Id: printerdb.cpp,v 1.1 1999/09/14 00:26:28 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: printerdb.cpp,v $
    Revision 1.1  1999/09/14 00:26:28  wdl
    Restructuring of directories

    Revision 1.8  1999/09/09 11:28:44  stephan
    Fixed some things for the new spool handling

    Revision 1.7  1999/08/30 15:48:19  stephan
    Bug fixes

    Revision 1.6  1999/08/27 16:43:03  wdl
    Standard Headers

 ***************************************************************************/
#include "printerdb.h"

printerDB::printerDB(){
	// first parse manufactor file
	t_file = new QFile();
	dbDIR = kapp->kde_datadir() + "/kpcwizard/db/";
	QString *dbFile = new QString(dbDIR.data());
	dbFile->append("manufactors");
	int count;
	QString *tmpStr = new QString;
	QString *tmp0 = new QString;
	printerDBmanufactor *tmpManu = new printerDBmanufactor();
  ManufactorLst.clear();
	t_file->setName(dbFile->data());
	if(!t_file->exists()) {
		if(QMessageBox::critical(0,"Database not found!","Printer db file ($KDEDIR/kpcwizard/db/manufactors) could not be found!\nWithout this file kpc doesnt work!") == 0) exit(0);
	}
	delete(t_file);
	config = new KSimpleConfig(dbFile->data(),true);
	config->setGroup("global");
	for(count = 1; count <= config->readNumEntry("ManNo"); count++){
		tmpStr->setNum(count);
		tmpStr->prepend("Man");		
		*tmp0 = config->readEntry(tmpStr->data());
		config->setGroup( tmp0->data() );
		tmpManu->setName( tmp0->data() );
		tmpManu->setLogo(config->readEntry("icon","none.xpm"));
		tmpManu->setWeb(config->readEntry("web","none"));
		tmpManu->setModelFile(config->readEntry("printerfile"));
		ManufactorLst.append(new printerDBmanufactor(*tmpManu));
	  config->setGroup("global");
	}
	delete(tmpStr); delete(dbFile);
	delete(tmpManu); delete(tmp0);
}

printerDB::~printerDB(){
	delete(config);
}


QList<QString> printerDB::getPrinterLst(const char *manufactor){
	printerDBmanufactor *tmpManu = new printerDBmanufactor;
	QString *tmpStr = new QString();
	QString *tmp0 = new QString();
	t_file = new QFile();
	QList<QString> tmpLst;
	int count; tmpLst.clear();
	for(tmpManu = ManufactorLst.first(); tmpManu != 0; tmpManu = ManufactorLst.next()){
		if(strcmp(tmpManu->getName(),manufactor) == 0){
			*tmp0 = tmpManu->getModelFile();
			tmp0->prepend(dbDIR.data());
			t_file->setName(tmp0->data());
			if(!t_file->exists()) {
				if(QMessageBox::critical(0,"PrinterDB Error","Error while loading Modelfile!")==0) exit(0);
			}
			delete(t_file);
			KSimpleConfig *myconfig = new KSimpleConfig(tmp0->data(),true);
			myconfig->setGroup("global");
			for(count = 1; count <= myconfig->readNumEntry("ModelNo"); count++){
				tmpStr->setNum(count);
				tmpStr->prepend("Model");
				*tmp0 = myconfig->readEntry(tmpStr->data());
				tmpLst.append(new QString(myconfig->readEntry(tmpStr->data())));				
			}
			delete(myconfig);
		}
	}
	delete(tmpManu);
	delete(tmpStr);
	return tmpLst;
}

QList<QString> printerDB::getManufactorNameLst(){
	printerDBmanufactor *tmpManu = new printerDBmanufactor;
	QList<QString> tmpLst;
	tmpLst.clear();
	for(tmpManu = ManufactorLst.first(); tmpManu != 0; tmpManu = ManufactorLst.next()){
		tmpLst.append(new QString(tmpManu->getName()));
	}
	delete(tmpManu);
	return tmpLst;
}

printerDBentry printerDB::getPrinterSPEC(const char *manufactor,const char *modelname){
	printerDBmanufactor *tmpManu = new printerDBmanufactor;
	QString *tmpStr = new QString();
	QString t_Str;
	t_file = new QFile;
	printerDBentry *tmpEntry = new printerDBentry();
	int count;
	t_Str = dbDIR;
	for(tmpManu = ManufactorLst.first(); tmpManu != 0; tmpManu = ManufactorLst.next()){
		if(strcmp(tmpManu->getName(),manufactor) == 0){
			t_file->setName((new QString(t_Str + tmpManu->getModelFile()))->data());
			if(!t_file->exists()) {
				if(QMessageBox::critical(0,"PrinterDB error!","Could not load printer specifications! File not found") == 0) exit(0);
			}
			delete(t_file);
			KSimpleConfig *myconfig = new KSimpleConfig(t_Str.append(tmpManu->getModelFile()).data(),true);
			t_Str = dbDIR;
			myconfig->setGroup("global");
			for(count = 1; count <= myconfig->readNumEntry("ModelNo"); count++){
				tmpStr->setNum(count);
				tmpStr->prepend("Model");
				if(strcmp(myconfig->readEntry(tmpStr->data()),modelname) == 0){
					myconfig->setGroup( modelname );
					tmpEntry->setModelName(modelname);
				  tmpEntry->setGSdriver(myconfig->readEntry("GSDriver").data());
					tmpEntry->setGSoptions(myconfig->readEntry("GSOptions").data());
					tmpEntry->setManufactor(manufactor);
					tmpEntry->setPaperFormats(myconfig->readEntry("PaperFormats").data());
					tmpEntry->setMonoRes(myconfig->readEntry("MonoRes").data());
        	tmpEntry->setColorRes(myconfig->readEntry("ColorRes").data());	
								
				}				
			}
			delete(myconfig);
		}
	}
	//delete(t_file);
	delete(tmpManu);
	delete(tmpStr);
	return *(new printerDBentry(*tmpEntry));
}
















