/***************************************************************************
    $Id: lpdfilter.cpp,v 1.1 1999/09/14 00:26:27 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: lpdfilter.cpp,v $
    Revision 1.1  1999/09/14 00:26:27  wdl
    Restructuring of directories

    Revision 1.1  1999/09/12 10:25:52  stephan
    Added a filter handler for unix/lpd hosts

    Revision 1.2  1999/08/27 16:21:21  wdl
    Standard Headers

 ***************************************************************************/

#include "lpdfilter.h"

LPDfilter::LPDfilter(apsfilter &apsCfg,const char *_host,const char *_spool){
	apsfilterName = apsCfg.getFilterName();
	Filterpath = apsCfg.getPathToFilter();
	host = _host; spool = _spool;
}

LPDfilter::~LPDfilter(){
}

const char *LPDfilter::getFilterName() {
	return (new QString(Filterpath + "/lpdfilter"))->data();
}

void LPDfilter::setup(){
	QFile *t_file = new QFile(Filterpath + "/lpdfilter");
	t_file->open(IO_WriteOnly);
	QTextStream *t_stream = new QTextStream(t_file);
	*t_stream << "#!/bin/sh -x" << endl;
	*t_stream << "(" << endl;
	*t_stream << "cat" << endl << ") | " << apsfilterName.data();
	*t_stream << " | rlpr -H" << host.data() << " -P" << spool.data() << endl;
	t_file->flush();
	t_file->close();
	delete(t_file);
}

bool LPDfilter::check(){
	#warning rlpr check needs heavy improvements
 if(system("which rlpr") != 0) return false;
 return true;	
}






