/************************************************************************
 * kcreateinst - part of kinst package - tgzcompose.cpp                 *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "tgzcompose.h"
#include "tparams.h"
#include "locale.h"
#include "stringfunc.h"

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <qdialog.h>
#include <qframe.h>
#include <kfm.h>
#include <qmessagebox.h>
#include <qtooltip.h>

#ifndef MIN_WIDTH
#define MIN_WIDTH 520
#endif

#ifndef MIN_HEIGHT
#define MIN_HEIGHT 500
#endif

#ifndef EOL
#define EOL 10
#endif

// MOC
#include "tgzcompose.moc"

tTGZComposeDlg::tTGZComposeDlg(QWidget *parent, const char *name)
  : QDialog(parent, name, true)
{

#include "filenew.xpm"
#include "filedel.xpm"

  QPixmap new_picture(filenew_xpm);
  QPixmap del_picture(delete_xpm);

  // General properties
  setCaption(_i18n("kcreateinst - Compose TGZ"));
  resize(MIN_WIDTH, MIN_HEIGHT);
  setMinimumWidth(MIN_WIDTH);
  setMinimumHeight(MIN_HEIGHT);

  // Create Head1
  Head1 = new QLabel(this);
  Head1->setText(_i18n("Your actual TGZ"));
  Head1->show();

  // Create Head2
  Head2 = new QLabel(this);
  Head2->setText(_i18n("Your system's directory"));
  Head2->show();

  // Create TGZ_label
  TGZ_label = new QLabel(this);
  TGZ_label->setText(_i18n("Filename of the TGZ to be created"));
  TGZ_label->show();

  // Create TGZ_edit
  TGZ_edit = new QLineEdit(this);
  TGZ_edit->clear();
  TGZ_edit->show();

  // Create TGZ_button
  TGZ_button = new QPushButton(this);
  TGZ_button->setText(_i18n("Browse"));
  TGZ_button->show();
  connect(TGZ_button, SIGNAL(clicked()), SLOT(BrowsePressed()));

  // Create temporary directory
  tmpnam(tempdirname);
  mkdir(tempdirname, 0755);

  // Create Contents
  Contents = new QListView(this);
  Contents->clear();
  Contents->setFrameStyle(QFrame::Panel|QFrame::Sunken);
  Contents->setTreeStepSize(20);
  Contents->addColumn(_i18n("File"));
  Contents->setColumnWidthMode(0, QListView::Manual);
  Contents->show();
  ContentsDir = new kcreateinstDirectory(Contents, tempdirname);
  ContentsDir->setBaseDir(tempdirname);
  ContentsDir->setOpen(true);

  // Create DirBox
  DirBox = new QListView(this);
  DirBox->clear();
  DirBox->setFrameStyle(QFrame::Panel|QFrame::Sunken);
  DirBox->setTreeStepSize(20);
  DirBox->addColumn(_i18n("File"));
  DirBox->setColumnWidthMode(0, QListView::Manual);
  DirBox->show();
  DirBoxDir = new kcreateinstDirectory(DirBox);
  DirBoxDir->setOpen(true);

  // Create add_button
  add_button = new QPushButton(this);
  add_button->setText(_i18n("<<"));
  add_button->show();
  connect(add_button, SIGNAL(clicked()), SLOT(add_pressed()));

  // Create remove_button
  remove_button = new QPushButton(this);
  remove_button->setText(_i18n(">>"));
  remove_button->show();
  connect(remove_button, SIGNAL(clicked()), SLOT(remove_pressed()));

  // Create remove2_button
  remove2_button = new QToolButton(this);
  remove2_button->setPixmap(del_picture);
  remove2_button->setUsesBigPixmap(true);
  remove2_button->show();
  connect(remove2_button, SIGNAL(clicked()), SLOT(remove_pressed()));
  QToolTip::add(remove2_button, _i18n("Remove file/folder from archive"));

  // Create newdir_button
  newdir_button = new QToolButton(this);
  newdir_button->setPixmap(new_picture);
  newdir_button->setUsesBigPixmap(true);
  newdir_button->show();
  connect(newdir_button, SIGNAL(clicked()), SLOT(newdir_pressed()));
  QToolTip::add(newdir_button, _i18n("Create new folder in archive"));

  // Create cancel_button
  cancel_button = new QPushButton(this);
  cancel_button->setText(_i18n("Cancel"));
  cancel_button->show();
  connect(cancel_button, SIGNAL(clicked()), SLOT(cancel_pressed()));

  // Create ok button
  ok_button = new QPushButton(this);
  ok_button->setText(_i18n("Create"));
  ok_button->show();
  connect(ok_button, SIGNAL(clicked()), SLOT(ok_pressed()));

  // Create Help button
  help_button = new QPushButton(this);
  help_button->setText(_i18n("Help"));
  help_button->show();
  connect(help_button, SIGNAL(clicked()), SLOT(help_pressed()));

  // Create status_label
  status_label = new QLabel(this);
  status_label->setFrameStyle(QFrame::Sunken|QFrame::Box);
  status_label->setMargin(1);
  status_label->setText(_i18n("Ready."));
  status_label->show();

  // Create File Selection Dialog
  FileSelector = new KFileDialog(getenv("HOME"), "*", this, "FileSelector",
				 false, false);
  FileSelector->hide();

  // Create newdirdlg
  newdirdlg = new DlgLocation(_i18n("Name of the new directory?"),
			      _i18n("Directory"), this);
  newdirdlg->hide();
}

void tTGZComposeDlg::resizeEvent(QResizeEvent*)
{
  // Resize Contents
  Contents->setGeometry(10,
			90,
			(width()-20)/2-20,
			height()-155);
  Contents->setColumnWidth(0, Contents->width());

  // Resize DirBox
  DirBox->setGeometry(Contents->x()+Contents->width()+40,
		      Contents->y(),
		      (width()-20)/2-20,
		      height()-155);
  DirBox->setColumnWidth(0, DirBox->width());

  // Resize Head1
  Head1->setGeometry(Contents->x(),
		     Contents->y()-17,
		     Contents->width()-58,
		     15);

  // Resize Head2
  Head2->setGeometry(DirBox->x(),
		     DirBox->y()-17,
		     DirBox->width(),
		     15);

  // Resize TGZ_label
  TGZ_label->setGeometry(10,
			 10,
			 width()-20,
			 15);

  // Resize TGZ_edit
  TGZ_edit->setGeometry(TGZ_label->x(),
			TGZ_label->y()+TGZ_label->height()+2,
			width()-90,
			20);

  // Resize TGZ_button
  TGZ_button->setGeometry(TGZ_edit->x()+TGZ_edit->width()+5,
			  TGZ_edit->y()-2,
			  width()-TGZ_edit->x()-TGZ_edit->width()-15,
			  TGZ_edit->height()+4);

  // Resize add_button
  add_button->setGeometry(Contents->x()+Contents->width()+5,
			  Contents->y()+(Contents->height()/2)-50,
			  30,
			  40);

  // Resize remove_button
  remove_button->setGeometry(Contents->x()+Contents->width()+5,
			     Contents->y()+(Contents->height()/2)+10,
			     30,
			     40);

  // Resize OK button
  ok_button->setGeometry(10,
			 height()-35,
			 90,
			 30);

  // Resize help_button
  help_button->setGeometry(width()-100,
			   height()-35,
			   90,
			   30);

  // Resize cancel_button
  cancel_button->setGeometry((width()/2)-45,
			     height()-35,
			     90,
			     30);

  // Resize newdir_button
  newdir_button->setGeometry(Head1->x()+Head1->width()+5,
			     Head1->y()-10,
			     25,
			     25);

  // Resize remove2_button
  remove2_button->setGeometry(newdir_button->x()+newdir_button->width()+2,
			      Head1->y()-10,
			      25,
			      25);

  // Resize status_label
  status_label->setGeometry(ok_button->x(),
			    ok_button->y()-25,
			    width()-20,
			    20);
}

QString tTGZComposeDlg::ComposeTGZ()
{
  show();

  return(TGZ_filename);
}

void tTGZComposeDlg::closeEvent(QCloseEvent *e)
{
  e->ignore();
}

void tTGZComposeDlg::BrowsePressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", this,
					 "Browse");
  if(qstrlen(String) > 0)
    {
      TGZ_filename = String;
      TGZ_edit->setText(String);
    }

  FileSelector->hide();
}

void tTGZComposeDlg::add_pressed()
{
  kcreateinstDirectory* p;
  kcreateinstDirectory* p2;
  char s[FILENAME_MAX];
  char s2[FILENAME_MAX];
  char s3[FILENAME_MAX];
  char command[65535];

  status_label->setText(_i18n("Adding..."));
  kapp->processEvents();

  strcpy(s, "");
  strcpy(s2, "");
  strcpy(s3, "");

  p = (kcreateinstDirectory*) DirBox->currentItem();

  if(p == NULL)
    {
      QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			   _i18n("You must select an item to be copied first."));
      return;
    }

  if(strcmp(p->text(1), "Directory") == 0)
    p->dirPath(s, FILENAME_MAX);
  else
    strncpy(s, p->text(1), FILENAME_MAX);
  if(strcmp(p->text(1), "Unreadable Directory") == 0)
    {
      QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			   _i18n("The selected directory is unreadable and cannot be copied."));
      return;
    }

  p2 = (kcreateinstDirectory*) Contents->currentItem();

  if(p2 == NULL)
    strncpy(s2, tempdirname, FILENAME_MAX);
  else
    {
      if(strcmp(p2->text(1), "Directory") == 0)
	{
	  p2->dirPath(s3, FILENAME_MAX);
	  _strncat(s2, s3, FILENAME_MAX);
	}
      else
	strncpy(s2, tempdirname, FILENAME_MAX);
      if(strcmp(p2->text(1), "Unreadable Directory") == 0)
	{
	  QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			       _i18n("The selected target directory is unreadable."));
	  return;
	}
    }

#ifdef _DEBUG_
  printf("tgzcompose:  %s selected for addition\n", s);
  printf("tgzcompose:  %s selected as target directory\n", s2);
#endif

  strcpy(command, "cp -f -r \"");
  _strncat(command, s, 65535);
  _strncat(command, "\" \"", 65535);
  _strncat(command, s2, 65535);
  _strncat(command, "\"", 65535);

#ifdef _DEBUG_
  printf("tgzcompose:  command is: %s\n", command);
#endif

  system(command);

  update_dirboxes();

  status_label->setText(_i18n("Ready."));
}

void tTGZComposeDlg::remove_pressed()
{
  kcreateinstDirectory* p;
  char s[FILENAME_MAX];
  char s2[FILENAME_MAX];
  char command[65535];

  status_label->setText(_i18n("Removing..."));
  kapp->processEvents();

  strcpy(s, "");
  strcpy(s2, "");

  p = (kcreateinstDirectory*) Contents->currentItem();

  if(p == NULL)
    {
      QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			   _i18n("You must select an item to be removed first."));
      return;
    }

  if(strcmp(p->text(1), "Directory") == 0)
    {
      p->dirPath(s2, FILENAME_MAX);
      _strncat(s, s2, FILENAME_MAX);
    }
  else
    {
      _strncat(s, p->text(1), FILENAME_MAX);
    }
  if(strcmp(p->text(1), "Unreadable Directory") == 0)
    {
      QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			   _i18n("The selected directory is unreadable and cannot be removed."));
      return;
    }

#ifdef _DEBUG_
  printf("tgzcompose:  %s selected for removal\n", s);
#endif

  strcpy(command, "rm -f -r \"");
  _strncat(command, s, 65535);
  _strncat(command, "\"", 65535);

#ifdef _DEBUG_
  printf("tgzcompose:  command is: %s\n", command);
#endif

  system(command);

  update_dirboxes();

  status_label->setText(_i18n("Ready."));
}

void tTGZComposeDlg::update_dirboxes()
{
  // DirBox->clear();
  Contents->clear();
  // DirBoxDir = new kcreateinstDirectory(DirBox);
  // DirBoxDir->setOpen(true);
  ContentsDir = new kcreateinstDirectory(Contents, tempdirname);
  ContentsDir->setBaseDir(tempdirname);
  ContentsDir->setOpen(true);
}

void tTGZComposeDlg::ok_pressed()
{
  char s[FILENAME_MAX];
  char olddir[FILENAME_MAX];
  int err;

  TGZ_filename = TGZ_edit->text();

  if(qstrlen(TGZ_filename) <= 0)
    {
      QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			   _i18n("You have to select a TGZ target file first."));
      return;
    }

  getcwd(olddir, FILENAME_MAX);

  if(!(chdir(tempdirname) == 0))
    {
      QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			   _i18n("Fatal error: Cannot change to temporary directory. Unable to create TGZ."));
      return;
    }

  strcpy(s, "tar cfz \"");
  _strncat(s, TGZ_filename, FILENAME_MAX);
  _strncat(s, "\" *", FILENAME_MAX);

#ifdef _DEBUG_
  printf("tgzcompose:  Invoking command %s to compress files\n", s);
#endif

  status_label->setText(_i18n("Creating TAR-GZ..."));
  kapp->processEvents();

  err = system(s);

  if((err == 127) || (err == -1))
    QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			 _i18n("Fatal error: TAR command failed. Unable to create TGZ."));

  if(!(chdir(olddir) == 0))
    QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			 _i18n("Warning: Cannot change to original working dir."));

  if((err == 127) || (err == -1)) return;

  if((tempdirname != NULL) && (strlen(tempdirname)) > 0)
    {
      strcpy(s, "rm -f -r \"");
      _strncat(s, tempdirname, 65535);
      _strncat(s, "\"", 65535);

#ifdef _DEBUG_
      printf("tgzcompose:  Trying do delete temporary directory\n");
#endif
      system(s);
    }

  status_label->setText(_i18n("Ready."));

  hide();
}

void tTGZComposeDlg::cancel_pressed()
{
  char s[FILENAME_MAX];

  TGZ_filename = "";

  if((tempdirname != NULL) && (strlen(tempdirname)) > 0)
    {
      strcpy(s, "rm -f -r \"");
      _strncat(s, tempdirname, 65535);
      _strncat(s, "\"", 65535);

#ifdef _DEBUG_
      printf("tgzcompose:  Trying do delete temporary directory\n");
#endif
      system(s);
    }

  hide();
}

void tTGZComposeDlg::help_pressed()
{
  kapp->invokeHTMLHelp("kcreateinst/tgzbuild.html", "");
}

void tTGZComposeDlg::newdir_pressed()
{
  char s[FILENAME_MAX];
  char s2[FILENAME_MAX];
  char newdir[FILENAME_MAX];
  kcreateinstDirectory* p;

  strcpy(newdir, "");
  strcpy(s2, "");

  newdirdlg->show();
  strncpy(s, newdirdlg->getText(), FILENAME_MAX);

  if((s == NULL) || (strlen(s) <= 0))
    return;

  p = (kcreateinstDirectory*) Contents->currentItem();

  if(p == NULL)
    {
      strcpy(newdir, tempdirname);
      _strncat(newdir, "/", FILENAME_MAX);
      _strncat(newdir, s, FILENAME_MAX);
    }
  else
    {
      if(strcmp(p->text(1), "Directory") == 0)
	{
	  p->dirPath(s2, FILENAME_MAX);
	  if(s2[strlen(s2)-1] != '/') _strncat(s2, "/", FILENAME_MAX);
	  _strncat(newdir, s2, FILENAME_MAX);
	  _strncat(newdir, s, FILENAME_MAX);
	}
      else
	{
	  strcpy(newdir, tempdirname);
	  _strncat(newdir, "/", FILENAME_MAX);
	  _strncat(newdir, s, FILENAME_MAX);
	}
      if(strcmp(p->text(1), "Unreadable Directory") == 0)
	{
	  QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			       _i18n("The selected directory is unreadable and cannot take new subdirectories."));
	  return;
	}
    }

#ifdef _DEBUG_
  printf("tgzcompose:  Trying to create %s\n", newdir);
#endif

  if(!(mkdir(newdir, 0755) == 0))
    QMessageBox::warning(this, _i18n("kcreateinst - Compose TGZ"),
			 _i18n("Could not create the new directory."));

  update_dirboxes();
}
